/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.setup;

import com.atlassian.bamboo.fileserver.SystemDirectory;
import com.atlassian.bamboo.setup.ServerFingerprint;
import com.atlassian.bamboo.util.BambooObjectUtils;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.security.random.DefaultSecureRandomService;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ServerFingerprintUtils {
    private static final Logger log = Logger.getLogger(ServerFingerprintUtils.class);
    private static final Supplier<ServerFingerprint> fingerprint = new Supplier<ServerFingerprint>(){

        @Override
        public ServerFingerprint get() {
            Long serverFingerprint;
            long newInstanceFingerprint = DefaultSecureRandomService.getInstance().nextLong();
            File serverStateDirectory = SystemDirectory.getServerStateDirectory();
            File serverFingerprintFile = new File(serverStateDirectory, "fingerprint");
            if (serverFingerprintFile.exists() && !SystemProperty.BAMBOO_IGNORE_SERVER_STATE_ON_RESTART.getTypedValue() && (serverFingerprint = ServerFingerprintUtils.readServerFingerprint(serverFingerprintFile)) != null) {
                return new ServerFingerprint(serverFingerprint.toString(), newInstanceFingerprint);
            }
            long newServerFingerprint = DefaultSecureRandomService.getInstance().nextLong();
            try {
                ServerFingerprintUtils.storeServerFingerprint(serverFingerprintFile, newServerFingerprint);
            }
            catch (IOException e) {
                throw BambooObjectUtils.asRuntimeException((Throwable)e);
            }
            return new ServerFingerprint(String.valueOf(newServerFingerprint), newInstanceFingerprint);
        }
    };

    private ServerFingerprintUtils() {
    }

    public static ServerFingerprint setupFingerPrint() {
        return fingerprint.get();
    }

    private static void storeServerFingerprint(File fingerprintFile, long newFingerprint) throws IOException {
        if (SystemProperty.PERSIST_RUNTIME_STATE.getTypedValue()) {
            FileUtils.writeStringToFile((File)fingerprintFile, (String)String.valueOf(newFingerprint), (Charset)StandardCharsets.UTF_8);
        }
    }

    @Nullable
    public static Long readServerFingerprint(File fingerprintFile) {
        try {
            String previousFingerprint = FileUtils.readFileToString((File)fingerprintFile).trim();
            if (!previousFingerprint.isEmpty() && NumberUtils.isCreatable((String)previousFingerprint)) {
                return Long.valueOf(previousFingerprint);
            }
            log.warn((Object)("Ignoring previous fingerprint: " + previousFingerprint));
        }
        catch (IOException e) {
            log.warn((Object)("Unable to read fingerprint file: " + e.getMessage()), (Throwable)e);
        }
        return null;
    }
}

