/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.setup;

import com.atlassian.bamboo.setup.BrokerURIUtils;
import com.atlassian.bamboo.upgrade.AbstractBootstrapUpgradeTask;
import java.net.URI;
import org.apache.log4j.Logger;

public class ResetBrokerUrlUpgradeTask
extends AbstractBootstrapUpgradeTask {
    private static final Logger log = Logger.getLogger(ResetBrokerUrlUpgradeTask.class);
    private static final String PROPERTY_TO_REMOVE = "wireFormat.maxInactivityDuration";

    public ResetBrokerUrlUpgradeTask() {
        super("1103", "Resets the Broker URL to the recommended parameters.");
    }

    public void doUpgrade() throws Exception {
        URI brokerClientURI;
        URI brokerUri = this.bootstrapManager.getBrokerURI();
        if (brokerUri.toString().contains(PROPERTY_TO_REMOVE)) {
            URI newBrokerUrl = BrokerURIUtils.removeParameter(brokerUri, PROPERTY_TO_REMOVE);
            this.bootstrapManager.setBrokerURI(newBrokerUrl);
        }
        if ((brokerClientURI = this.bootstrapManager.getBrokerClientURI()).toString().contains(PROPERTY_TO_REMOVE)) {
            URI newBrokerUrl = BrokerURIUtils.removeParameter(brokerClientURI, PROPERTY_TO_REMOVE);
            this.bootstrapManager.setBrokerClientURI(newBrokerUrl);
        }
        this.bootstrapManager.setBrokerURI(this.bootstrapManager.getBrokerURI());
        this.bootstrapManager.setBrokerClientURI(this.bootstrapManager.getBrokerClientURI());
    }
}

