/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.setup;

import com.atlassian.bamboo.process.BambooProcessHandler;
import com.atlassian.bamboo.setup.BambooHomeLocator;
import com.atlassian.bamboo.setup.BootstrapManager;
import com.atlassian.bamboo.setup.H2DatabaseUpgrader;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.bamboo.utils.BambooPathUtils;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.atlassian.config.ApplicationConfig;
import com.atlassian.upgrade.UpgradeException;
import com.atlassian.utils.process.BaseOutputHandler;
import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.ExternalProcessBuilder;
import com.atlassian.utils.process.OutputHandler;
import com.atlassian.utils.process.ProcessException;
import com.atlassian.utils.process.ProcessHandler;
import com.google.common.collect.ImmutableList;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.Logger;
import org.h2.tools.RunScript;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Lazy;

public class H2DatabaseUpgraderImpl
implements H2DatabaseUpgrader {
    private static final Logger log = Logger.getLogger(H2DatabaseUpgraderImpl.class);
    @Inject
    private BambooHomeLocator bambooHomeLocator;
    @Inject
    @Lazy
    private DbmsBean dbmsBean;
    @Inject
    private ApplicationConfig applicationConfig;

    @Override
    public void upgradeH2Database(@NotNull BootstrapManager bootstrapManager) throws UpgradeException {
        if (!this.dbmsBean.isH2()) {
            bootstrapManager.resetH2Version();
            return;
        }
        String dbUrl = this.applicationConfig.getProperty((Object)"hibernate.connection.url").toString();
        String dbFileName = dbUrl.substring(dbUrl.lastIndexOf("database") + "database".length() + 1) + ".mv.db";
        log.info((Object)"Current database is H2, checking if it requires update...");
        String h2Version = bootstrapManager.getH2VersionFromConfig();
        if (!BuildUtils.getH2Version().equals(h2Version)) {
            log.info((Object)("Upgrading from H2 version " + h2Version + " ..."));
            File h2UpgradeWorkingDir = new File(this.bambooHomeLocator.getHomePath(), "h2temp");
            h2UpgradeWorkingDir.mkdirs();
            File h2DbFile = new File(new File(this.bambooHomeLocator.getHomePath(), "database"), dbFileName);
            if (!h2DbFile.exists()) {
                log.info((Object)"H2 database is empty");
                return;
            }
            File backupFile = new File(h2UpgradeWorkingDir, dbFileName);
            try {
                FileUtils.copyFile((File)h2DbFile, (File)backupFile);
            }
            catch (IOException ex) {
                throw new UpgradeException("Failed to create database backup. Make sure that home directory is writable", (Throwable)ex);
            }
            File oldH2JarFile = this.downloadOldH2Lib(h2UpgradeWorkingDir, h2Version);
            try {
                this.dumpDatabase(h2UpgradeWorkingDir, h2DbFile, oldH2JarFile, backupFile);
            }
            catch (IOException ex) {
                throw new UpgradeException("Failed to create database dump. Aborting.", (Throwable)ex);
            }
            this.restoreDatabaseFromDump(h2UpgradeWorkingDir, h2DbFile, backupFile);
            BambooPathUtils.deleteQuietly((Path)h2UpgradeWorkingDir.toPath());
        }
        bootstrapManager.resetH2Version();
    }

    private void restoreDatabaseFromDump(File h2UpgradeWorkingDir, File h2DbFile, File backupFile) throws UpgradeException {
        try {
            String dbUrl = this.applicationConfig.getProperty((Object)"hibernate.connection.url").toString();
            String username = this.applicationConfig.getProperty((Object)"hibernate.connection.username").toString();
            File scriptFile = new File(h2UpgradeWorkingDir, "db-dump.sql");
            BambooPathUtils.forceDelete((Path)h2DbFile.toPath());
            RunScript runScript = new RunScript();
            runScript.runTool(new String[]{"-url", dbUrl, "-user", username, "-script", scriptFile.getAbsolutePath(), "-checkResults"});
        }
        catch (Exception e) {
            this.restoreFromBackup(h2DbFile, backupFile, "Failed to restore from database dump. Aborting.");
            throw new UpgradeException("Failed to restore from database dump. Aborting.", (Throwable)e);
        }
    }

    private void restoreFromBackup(File h2DbFile, File backupFile, String s) throws UpgradeException {
        try {
            FileUtils.copyFile((File)backupFile, (File)h2DbFile);
        }
        catch (IOException ioException) {
            throw new UpgradeException(s + "\n Failed to restore database from the backup file. Database backup file can be found at " + backupFile.getAbsolutePath(), (Throwable)ioException);
        }
    }

    private void dumpDatabase(File h2UpgradeWorkingDir, File h2DbFile, File oldH2JarFile, File backupFile) throws IOException, UpgradeException {
        String javaBinary = String.join((CharSequence)File.separator, SystemUtils.JAVA_HOME, "bin", SystemUtils.IS_OS_WINDOWS ? "java.exe" : "java");
        String dbUrl = this.applicationConfig.getProperty((Object)"hibernate.connection.url").toString();
        String username = this.applicationConfig.getProperty((Object)"hibernate.connection.username").toString();
        FileUtils.writeStringToFile((File)new File(h2UpgradeWorkingDir, "query.sql"), (String)"SCRIPT TO 'db-dump.sql'\n");
        RedirectToAppLogOutputHandler outputHandler = new RedirectToAppLogOutputHandler();
        BambooProcessHandler handler = new BambooProcessHandler((OutputHandler)outputHandler, (OutputHandler)outputHandler);
        ExternalProcessBuilder processBuilder = new ExternalProcessBuilder().command((List)ImmutableList.of((Object)javaBinary, (Object)"-cp", (Object)oldH2JarFile.toString(), (Object)"org.h2.tools.RunScript", (Object)"-url", (Object)dbUrl, (Object)"-user", (Object)username, (Object)"-script", (Object)"query.sql"), h2UpgradeWorkingDir);
        processBuilder.handler((ProcessHandler)handler);
        ExternalProcess process = processBuilder.build();
        process.execute();
        if (!handler.succeeded()) {
            this.restoreFromBackup(h2DbFile, backupFile, "Failed to create database dump. Aborting.");
            throw new UpgradeException("Failed to create database dump. Aborting.");
        }
    }

    private File downloadOldH2Lib(File h2UpgradeWorkingDir, String oldH2Version) throws UpgradeException {
        String jarFileName = "h2-" + oldH2Version + ".jar";
        File jarFile = new File(h2UpgradeWorkingDir, jarFileName);
        if (jarFile.exists()) {
            return jarFile;
        }
        String sourceUrlString = "https://repo1.maven.org/maven2/com/h2database/h2/" + oldH2Version + "/" + jarFileName;
        try {
            URL jarSourceUrl = new URL(sourceUrlString);
            FileUtils.copyURLToFile((URL)jarSourceUrl, (File)jarFile);
        }
        catch (IOException ex) {
            throw new UpgradeException("Failed to download H2 library from " + sourceUrlString + ". Download it manually and copy it into: " + jarFile.toString(), (Throwable)ex);
        }
        return jarFile;
    }

    private static class RedirectToAppLogOutputHandler
    extends BaseOutputHandler {
        private RedirectToAppLogOutputHandler() {
        }

        public void process(InputStream inputStream) throws ProcessException {
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    this.resetWatchdog();
                    log.info((Object)line);
                }
                log.debug((Object)"Ending pump");
            }
            catch (InterruptedIOException e) {
                log.debug((Object)("Pump interrupted " + Thread.currentThread().isInterrupted()), (Throwable)e);
            }
            catch (Throwable e) {
                log.info((Object)"Failed to pump input stream. Internal error", e);
                throw new ProcessException(e);
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
        }
    }
}

