/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.setup;

import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.config.ConfigurationException;
import com.atlassian.config.setup.SetupException;
import com.atlassian.config.setup.SetupPersister;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.List;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class DefaultSetupPersister
implements SetupPersister {
    private static final Logger log = Logger.getLogger(DefaultSetupPersister.class);
    public static final String SETUP_LICENSE_STEP = "setupLicense";
    public static final String SETUP_DB = "setupDatabase";
    public static final String SETUP_DATA = "setupSelectImport";
    public static final String SETUP_GENERAL = "setupGeneralConfiguration";
    public static final String SETUP_ADMIN = "setupAdminUser";
    public static final String SETUP_FINISH = "finishsetup";
    public static final String SETUP_DEFAULT_GENERAL = "setupDefaultGeneral";
    public static final String SETUP_DEFAULT_DATABASE = "setupDefaultDatabase";
    private Stack<String> setupStack;
    private Stack<String> finishedStack;
    private ApplicationConfiguration applicationConfig;

    public List<String> getUncompletedSteps() {
        ArrayList<String> reversedSteps = new ArrayList<String>(this.getSetupStack());
        Collections.reverse(reversedSteps);
        return reversedSteps;
    }

    public List<String> getCompletedSteps() {
        return new ArrayList<String>(this.finishedStack);
    }

    public String getSetupType() {
        return this.applicationConfig.getSetupType();
    }

    public void setSetupType(String setupType) {
        if (StringUtils.isBlank((CharSequence)setupType)) {
            setupType = "initial";
        }
        try {
            this.applicationConfig.setSetupType(setupType);
            this.applicationConfig.save();
            this.configureSetupSequence(setupType);
        }
        catch (ConfigurationException e) {
            log.error((Object)("Could not save setupType:" + (Object)((Object)e)));
        }
    }

    public void finishSetup() throws SetupException {
        String currentStep = this.getCurrentStep();
        if (!currentStep.equals("complete")) {
            log.warn((Object)"Tried to finish setup but had not run through the whole wizard?");
            log.warn((Object)("Current step was " + currentStep));
            this.applicationConfig.setCurrentSetupStep("complete");
        }
        try {
            log.info((Object)"Setup complete");
            this.applicationConfig.setSetupComplete(true);
            this.applicationConfig.save();
        }
        catch (ConfigurationException e) {
            log.fatal((Object)("Error writing state to bamboo.cfg.xml: " + e.getMessage()));
        }
    }

    public void progessSetupStep() {
        try {
            String completedStep = this.getSetupStack().pop();
            this.finishedStack.push(completedStep);
            if (!this.getSetupStack().empty()) {
                String newCurrentStep = this.getSetupStack().peek();
                this.setCurrentStep(newCurrentStep);
            } else {
                log.error((Object)"setupStack is empty of actions.");
            }
        }
        catch (EmptyStackException e) {
            log.error((Object)"The setupStack is empty; the last action should always be 'complete', which will prohibit further setupStack activity! Odds are it wasn't in this case.");
        }
    }

    public String getCurrentStep() {
        String currentStep = this.applicationConfig.getCurrentSetupStep();
        if (StringUtils.isBlank((CharSequence)currentStep)) {
            currentStep = this.getSetupStack().peek();
            this.setCurrentStep(currentStep);
        }
        return currentStep;
    }

    public boolean isDemonstrationContentInstalled() {
        throw new UnsupportedOperationException();
    }

    public void setDemonstrationContentInstalled() {
        throw new UnsupportedOperationException();
    }

    private Stack<String> getSetupStack() {
        if (this.setupStack == null) {
            this.configureSetupSequence(this.getSetupType());
        }
        return this.setupStack;
    }

    private void configureSetupSequence(String setupType) {
        this.setupStack = new Stack();
        this.finishedStack = new Stack();
        if ("initial".equals(setupType)) {
            this.setupStack.add("complete");
            this.setupStack.add(SETUP_ADMIN);
            this.setupStack.add(SETUP_LICENSE_STEP);
        } else if ("custom".equals(setupType)) {
            this.setupStack.add("complete");
            this.setupStack.add(SETUP_FINISH);
            this.setupStack.add(SETUP_ADMIN);
            this.setupStack.add(SETUP_DATA);
            this.setupStack.add(SETUP_DB);
            this.setupStack.add(SETUP_GENERAL);
            this.setupStack.add(SETUP_LICENSE_STEP);
        } else if ("install".equals(setupType)) {
            this.setupStack.add("complete");
            this.setupStack.add(SETUP_FINISH);
            this.setupStack.add(SETUP_ADMIN);
            this.setupStack.add(SETUP_DEFAULT_DATABASE);
            this.setupStack.add(SETUP_DEFAULT_GENERAL);
            this.setupStack.add(SETUP_LICENSE_STEP);
        }
        String currentStep = this.getCurrentStep();
        this.synchSetupStackWithConfigRecord(currentStep);
    }

    private void synchSetupStackWithConfigRecord(String currentStep) {
        if (currentStep != null) {
            for (String step : this.getSetupStack()) {
                if (!step.equals(currentStep)) continue;
                while (!this.getSetupStack().peek().equals(currentStep)) {
                    this.finishedStack.push(this.getSetupStack().pop());
                }
            }
        }
    }

    private void setCurrentStep(String newCurrentStep) {
        log.info((Object)("Current setup step: " + newCurrentStep));
        this.applicationConfig.setCurrentSetupStep(newCurrentStep);
        try {
            this.applicationConfig.save();
        }
        catch (ConfigurationException e) {
            log.error((Object)"unable to record current bootstrapManager step to bamboo.cfg.xml");
        }
    }

    public void setApplicationConfig(ApplicationConfiguration applicationConfig) {
        this.applicationConfig = applicationConfig;
    }
}

