/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.setup;

import bucket.core.persistence.hibernate.schema.MetadataImplementorHolder;
import com.atlassian.bamboo.filter.AccessLogFilter;
import com.atlassian.bamboo.hibernate.BambooSchemaHelper;
import com.atlassian.bamboo.upgrade.utils.HikariConnectionPoolConfigurationHelper;
import com.atlassian.config.ConfigurationException;
import com.atlassian.config.db.DatabaseDetails;
import com.atlassian.config.db.HibernateConfigurator;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.spring.container.ContainerContext;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.base.Stopwatch;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.tool.hbm2ddl.SchemaExport;

public class DefaultHibernateConfigurator
implements HibernateConfigurator {
    private static final Logger log = Logger.getLogger(DefaultHibernateConfigurator.class);

    public synchronized void configureDatabase(DatabaseDetails dbDetails, boolean embedded) throws ConfigurationException {
        if (embedded) {
            String database_name = this.getH2DbName();
            dbDetails.setDatabaseUrl("jdbc:h2:" + database_name);
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("hibernate.connection.driver_class", dbDetails.getDriverClassName());
        properties.put("hibernate.connection.url", dbDetails.getDatabaseUrl());
        properties.put("hibernate.connection.username", dbDetails.getUserName());
        properties.put("hibernate.connection.password", dbDetails.getPassword());
        properties.put("hibernate.dialect", dbDetails.getDialect());
        properties.put("hibernate.connection.autocommit", "false");
        properties.put("hibernate.connection.provider_class", HikariConnectionPoolConfigurationHelper.HIKARI_CONNECTION_PROVIDER);
        properties.put("hibernate.hikari.minimumIdle", "3");
        properties.put("hibernate.hikari.maximumPoolSize", Integer.toString(dbDetails.getPoolSize()));
        properties.put("hibernate.hikari.idleTimeout", "120000");
        properties.put("hibernate.hikari.registerMbeans", "true");
        if (dbDetails.getExtraHibernateProperties() != null) {
            Properties extraHibernateConnectionSettings = dbDetails.getExtraHibernateProperties();
            for (String key : extraHibernateConnectionSettings.stringPropertyNames()) {
                properties.put(key, extraHibernateConnectionSettings.getProperty(key));
            }
        }
        this.refreshSpringContextAndCreateDatabase(properties);
    }

    protected String getH2DbName() {
        return "${bambooHome}/database/defaultdb";
    }

    public synchronized void configureDatasource(String datasourceName, String dialect) throws ConfigurationException {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("hibernate.connection.datasource", datasourceName);
        properties.put("hibernate.dialect", dialect);
        this.refreshSpringContextAndCreateDatabase(properties);
    }

    public void unconfigureDatabase() {
        Properties properties = BootstrapUtils.getBootstrapManager().getHibernateProperties();
        for (Object o : properties.keySet()) {
            BootstrapUtils.getBootstrapManager().removeProperty((String)o);
        }
        try {
            BootstrapUtils.getBootstrapManager().save();
        }
        catch (ConfigurationException e) {
            log.error((Object)("Unable to unconfigure failed database config: " + e.getMessage()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshSpringContextAndCreateDatabase(Map<String, String> properties) throws ConfigurationException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Configuring database with properties: " + properties));
        }
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            BootstrapUtils.getBootstrapManager().setProperty(entry.getKey(), (Object)entry.getValue());
        }
        log.info((Object)"Saving bootstrap configuration...");
        BootstrapUtils.getBootstrapManager().save();
        AccessLogFilter.setUsernameLoggingEnabled(false);
        log.info((Object)"Refreshing Spring context...");
        Stopwatch stopwatch = Stopwatch.createStarted();
        ContainerContext ctx = ContainerManager.getInstance().getContainerContext();
        ctx.refresh();
        log.info((Object)("Spring context refreshed after " + stopwatch));
        log.info((Object)"Creating Bamboo schema...");
        try {
            DefaultHibernateConfigurator.createBambooSchema();
        }
        catch (MappingException e) {
            log.error((Object)"Error creating Bamboo schema.", (Throwable)e);
        }
        finally {
            log.info((Object)"Bamboo schema created.");
        }
        AccessLogFilter.setUsernameLoggingEnabled(true);
        BootstrapUtils.getBootstrapManager().setProperty("hibernate.setup", (Object)"true");
    }

    public static void createBambooSchema() {
        try {
            SchemaExport schemaExport = new SchemaExport();
            log.setLevel(Level.DEBUG);
            boolean printDdlToConsole = log.isDebugEnabled();
            boolean loadDdlToDatabase = true;
            MetadataImplementor metadata = MetadataImplementorHolder.getMetadataImplementor();
            schemaExport.create(BambooSchemaHelper.getTargetTypes((boolean)printDdlToConsole, (boolean)true), (Metadata)metadata);
        }
        catch (HibernateException e) {
            log.error((Object)"", (Throwable)e);
        }
    }
}

