/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.setup;

import com.atlassian.bamboo.configuration.InetAddressBean;
import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.license.BambooLicenseManager;
import com.atlassian.bamboo.setup.BootstrapManager;
import com.atlassian.bamboo.setup.BrokerURIUtils;
import com.atlassian.bamboo.setup.H2DatabaseUpgrader;
import com.atlassian.bamboo.setup.ServerFingerprint;
import com.atlassian.bamboo.setup.ServerFingerprintUtils;
import com.atlassian.bamboo.upgrade.BootstrapUpgradeManager;
import com.atlassian.bamboo.upgrade.exception.ValidationException;
import com.atlassian.bamboo.upgrade.utils.HikariConnectionPoolConfigurationHelper;
import com.atlassian.bamboo.upgrade.utils.JtdsUpgrader;
import com.atlassian.bamboo.util.BambooConstantUtils;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.utils.db.DatabaseType;
import com.atlassian.config.ConfigurationException;
import com.atlassian.config.bootstrap.AtlassianBootstrapManager;
import com.atlassian.config.bootstrap.BootstrapException;
import com.atlassian.config.bootstrap.DefaultAtlassianBootstrapManager;
import com.atlassian.config.db.DatabaseDetails;
import com.atlassian.config.db.HibernateConfig;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.extras.api.bamboo.BambooLicense;
import com.atlassian.upgrade.UpgradeException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.opensymphony.xwork2.TextProvider;
import io.atlassian.util.concurrent.Lazy;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultBootstrapManager
extends DefaultAtlassianBootstrapManager
implements BootstrapManager {
    private static final Logger log = Logger.getLogger(DefaultBootstrapManager.class);
    private static final String DEFAULT_BROKER_BIND_ADDRESS = "nio://0.0.0.0:54663";
    private static final String DEFAULT_BROKER_CONNECTION_ADDRESS = "tcp://" + InetAddressBean.getLocalCanonicalHostName((String)"localhost") + ":54663";
    private static final String PROPERTY_INDEX_DIR = "lucene.index.dir";
    public static final String CONFIG_DIRECTORY_PARAM = "bamboo.config.directory";
    public static final String BUILD_DIRECTORY_PARAM = "bamboo.project.directory";
    private static final String BROKER_URI = "bamboo.jms.broker.uri";
    private static final String BROKER_CLIENT_URI = "bamboo.jms.broker.client.uri";
    public static final String BUILD_WORKING_DIR = "buildWorkingDir";
    public static final String ARTIFACTS_DIR = "bamboo.artifacts.directory";
    public static final String REPOSITORY_LOGS_PARAM = "bamboo.repository.logs.directory";
    private static final String H2_VERSION = "bamboo.h2.version";
    private static final String OLD_H2_VERSION = "1.4.196";
    private static final String CURRENT_H2_VERSION = BuildUtils.getH2Version();
    @VisibleForTesting
    static final String SERVER_KEY_PROPERTY = (String)BambooConstantUtils.preventInlining((Object)"serverKey");
    private static final Range<Integer> SERVER_KEY_RANGE = Range.between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(BambooEntityOid.SERVER_BITS_MASK));
    private static final Supplier<ServerFingerprint> fingerprint = Lazy.supplier(ServerFingerprintUtils::setupFingerPrint);
    @Inject
    private BootstrapUpgradeManager bootstrapUpgradeManager;
    @Inject
    private TextProvider textProvider;
    @Inject
    private H2DatabaseUpgrader h2DatabaseUpgrader;

    protected void afterConfigurationLoaded() throws ConfigurationException {
        if (!this.applicationConfig.configFileExists()) {
            this.applicationConfig.setBuildNumber(BuildUtils.getCurrentBuildNumber());
        }
        String homeDirBuildNumber = this.applicationConfig.getBuildNumber();
        String applicationBuildNumber = BuildUtils.getCurrentBuildNumber();
        if (Comparators.getApplicationBuildNumberComparator().compare(homeDirBuildNumber, applicationBuildNumber) > 0) {
            throw new ConfigurationException(String.format("Your build of Bamboo (%s) is too old to work with the data in your Bamboo home directory (%s), which comes from build number %s", applicationBuildNumber, this.applicationConfig.getApplicationHome(), homeDirBuildNumber));
        }
        try {
            this.getBrokerClientURI();
            this.getBrokerURI();
        }
        catch (URISyntaxException exception) {
            throw new ConfigurationException("Could not configure broker URIs", (Throwable)exception);
        }
    }

    public String getConfigDirectory() {
        return (String)this.getProperty(CONFIG_DIRECTORY_PARAM);
    }

    public void setConfigDirectory(String configurationDirectory) {
        this.setPropertyWithReplacement(CONFIG_DIRECTORY_PARAM, configurationDirectory);
    }

    public String getBuildWorkingDirectory() {
        return (String)this.getProperty(BUILD_WORKING_DIR);
    }

    public void setBuildWorkingDirectory(String buildWorkingDirectory) {
        this.setPropertyWithReplacement(BUILD_WORKING_DIR, buildWorkingDirectory);
    }

    public void setArtifactsDirectory(String artifactsDir) {
        this.setPropertyWithReplacement(ARTIFACTS_DIR, artifactsDir);
    }

    public String getArtifactsDirectory() {
        return (String)this.getProperty(ARTIFACTS_DIR);
    }

    @Nullable
    public File getIndexDirectory() {
        String indexPath = (String)this.getProperty(PROPERTY_INDEX_DIR);
        if (indexPath != null) {
            return new File(indexPath);
        }
        return null;
    }

    public String getBuildDirectory() {
        return (String)this.getProperty(BUILD_DIRECTORY_PARAM);
    }

    public void setBuildDirectory(String buildDirectory) {
        this.setPropertyWithReplacement(BUILD_DIRECTORY_PARAM, buildDirectory);
    }

    public String getRepositoryLogsDirectory() {
        return (String)this.getProperty(REPOSITORY_LOGS_PARAM);
    }

    public void setRepositoryLogsDirectory(@NotNull String repositoryLogsDirectory) {
        this.setPropertyWithReplacement(REPOSITORY_LOGS_PARAM, repositoryLogsDirectory);
    }

    void setPropertyWithReplacement(@NotNull String key, @Nullable Object value) {
        if (value instanceof String) {
            value = StringUtils.replace((String)((String)value), (String)this.getApplicationHome(), (String)"${bambooHome}");
        }
        this.setProperty(key, value);
    }

    public void publishConfiguration() {
        super.publishConfiguration();
        try {
            this.applicationConfig.save();
        }
        catch (ConfigurationException e) {
            log.error((Object)("Could not save setupType:" + (Object)((Object)e)));
        }
    }

    public URI getBrokerURI() throws URISyntaxException {
        String brokerURIString = new SystemProperty(false, new String[]{BROKER_URI}).getValue((String)this.getProperty(BROKER_URI));
        boolean blank = StringUtils.isBlank((CharSequence)brokerURIString);
        if (blank) {
            brokerURIString = DEFAULT_BROKER_BIND_ADDRESS;
        }
        URI brokerURI = new URI(brokerURIString);
        if (blank) {
            this.setBrokerURI(brokerURI);
        }
        return BrokerURIUtils.decorateBrokerURI(brokerURI);
    }

    public void setBrokerURI(URI brokerURI) {
        this.setProperty(BROKER_URI, brokerURI.toString());
    }

    public URI getBrokerClientURI() throws URISyntaxException {
        String brokerClientURIString = new SystemProperty(false, new String[]{BROKER_CLIENT_URI}).getValue((String)this.getProperty(BROKER_CLIENT_URI));
        boolean blank = StringUtils.isBlank((CharSequence)brokerClientURIString);
        if (blank) {
            brokerClientURIString = BrokerURIUtils.generateBrokerClientURI(this.determineBrokerConnectionAddress());
        }
        URI brokerClientURI = new URI(brokerClientURIString);
        if (blank) {
            this.setBrokerClientURI(brokerClientURI);
        }
        return BrokerURIUtils.decorateBrokerURI(brokerClientURI);
    }

    private String determineBrokerConnectionAddress() {
        boolean isRealHostAddress = false;
        URI brokerUri = null;
        try {
            brokerUri = this.getBrokerURI();
            InetAddress address = InetAddress.getByName(brokerUri.getHost());
            isRealHostAddress = !address.isAnyLocalAddress() && !address.isMulticastAddress() && address.isReachable(100);
        }
        catch (IOException | URISyntaxException exception) {
            // empty catch block
        }
        return isRealHostAddress ? brokerUri.getScheme() + "://" + brokerUri.getAuthority() : DEFAULT_BROKER_CONNECTION_ADDRESS;
    }

    public void setBrokerClientURI(URI brokerURI) {
        this.setProperty(BROKER_CLIENT_URI, brokerURI.toString());
    }

    protected boolean performPersistenceUpgrade() {
        BambooLicenseManager licenseManager = (BambooLicenseManager)BootstrapUtils.getBootstrapContext().getBean("bambooLicenseManager");
        BambooLicense license = licenseManager.getLicense();
        if (license != null && licenseManager.isMaintenanceExpiredForBuild()) {
            log.fatal((Object)"Unable to run pre-bootstrap upgrade tasks as your support period has ended");
            this.bootstrapFailureReason = "Unable to run pre-bootstrap upgrade tasks as your support period has ended. Please contact Atlassian Support at https://support.atlassian.com";
            return false;
        }
        String datasourceName = (String)this.getProperty("hibernate.connection.datasource");
        if (datasourceName == null && JtdsUpgrader.requiresUpgrade((HibernateConfig)this.hibernateConfig)) {
            try {
                this.runJtdsUpgrade();
            }
            catch (UpgradeException e) {
                this.bootstrapFailureReason = "Unable to upgrade jTDS JDBC driver settings: " + e.getMessage() + ".\nPlease consult our documentation at https://confluence.atlassian.com/x/KV4XN for details on manual upgrade process";
                return false;
            }
        }
        HikariConnectionPoolConfigurationHelper.reconfigureConnectionPoolIfRequired((AtlassianBootstrapManager)this);
        try {
            this.h2DatabaseUpgrader.upgradeH2Database(this);
        }
        catch (Exception e) {
            log.fatal((Object)"H2 database upgrade failed", (Throwable)e);
            this.bootstrapFailureReason = "Failed to run H2 database upgrade. Please contact Atlassian Support at https://support.atlassian.com";
            return false;
        }
        try {
            this.runValidationTasks();
        }
        catch (ValidationException e) {
            this.bootstrapFailureReason = e.getMessage();
            return false;
        }
        try {
            log.info((Object)"Running pre-bootstrap upgrade tasks");
            List errorMessages = this.bootstrapUpgradeManager.doUpgrade(false);
            if (!errorMessages.isEmpty()) {
                throw new UpgradeException("Pre-bootstrap upgrade tasks failed: " + errorMessages);
            }
            return true;
        }
        catch (Exception e) {
            log.fatal((Object)"Pre-bootstrap upgrade tasks failed", (Throwable)e);
            this.bootstrapFailureReason = "Failed to run pre-bootstrap upgrade tasks. Please contact Atlassian Support at https://support.atlassian.com";
            return false;
        }
    }

    protected void postBootstrapDatabase() throws BootstrapException {
        try {
            this.runValidationTasks();
        }
        catch (ValidationException e) {
            this.bootstrapFailureReason = e.getMessage();
            throw new BootstrapException((Throwable)e);
        }
    }

    protected String getDbUrl(DatabaseDetails dbDetails) {
        String dbDetailsDbUrl = super.getDbUrl(dbDetails);
        return StringUtils.replace((String)dbDetailsDbUrl, (String)"${bambooHome}", (String)this.getApplicationHome());
    }

    public String getServerID() {
        return (String)this.getProperty("serverId");
    }

    public void setServerID(String serverId) {
        this.setProperty("serverId", serverId);
    }

    public boolean initializeServerKey() {
        String serverKey = (String)this.getProperty(SERVER_KEY_PROPERTY);
        if (StringUtils.isEmpty((CharSequence)serverKey)) {
            String serverID = this.getServerID();
            Preconditions.checkState((boolean)StringUtils.isNotEmpty((CharSequence)serverID), (Object)"No server ID configured, can't initialize server key");
            this.setServerKey(serverID.hashCode() & BambooEntityOid.SERVER_BITS_MASK);
            return true;
        }
        return false;
    }

    public int getServerKey() {
        String serverKeyStr = (String)this.getProperty(SERVER_KEY_PROPERTY);
        Preconditions.checkState((boolean)StringUtils.isNotEmpty((CharSequence)serverKeyStr), (Object)"No server key configured");
        Preconditions.checkState((boolean)NumberUtils.isDigits((String)serverKeyStr), (Object)"Invalid server key value, must be a positive integer");
        Integer serverKey = Integer.valueOf(serverKeyStr);
        Preconditions.checkState((boolean)SERVER_KEY_RANGE.contains((Object)serverKey), (String)"Invalid server key value, not in allowed range: %d - %d", (Object)SERVER_KEY_RANGE.getMinimum(), (Object)SERVER_KEY_RANGE.getMaximum());
        return serverKey;
    }

    public void setServerKey(int serverKey) {
        Preconditions.checkArgument((boolean)SERVER_KEY_RANGE.contains((Object)serverKey), (String)"Invalid server key value, not in allowed range: %d - %d", (Object)SERVER_KEY_RANGE.getMinimum(), (Object)SERVER_KEY_RANGE.getMaximum());
        this.setProperty(SERVER_KEY_PROPERTY, String.valueOf(serverKey));
    }

    @NotNull
    public ServerFingerprint getFingerprint() {
        return fingerprint.get();
    }

    private void runValidationTasks() throws ValidationException {
        log.info((Object)"Running validation tasks");
        try {
            List validationErrorMessages = this.bootstrapUpgradeManager.runValidationTasks();
            if (!validationErrorMessages.isEmpty()) {
                log.fatal((Object)("Validation tests failed: " + validationErrorMessages.toString()));
                throw new ValidationException(this.textProvider.getText("validation.error.generic"));
            }
        }
        catch (ValidationException e) {
            log.fatal((Object)("Validation tests failed: " + e.getMessage()));
            throw e;
        }
    }

    private void runJtdsUpgrade() throws UpgradeException {
        log.debug((Object)String.format("Replacing jTDS JDBC details with Microsoft equivalents: Driver = [%s], URL = [%s]", this.hibernateConfig.getHibernateProperties().getProperty("hibernate.connection.driver_class"), this.hibernateConfig.getHibernateProperties().getProperty("hibernate.connection.url")));
        String url = JtdsUpgrader.rewriteUrl((HibernateConfig)this.hibernateConfig);
        this.setProperty("hibernate.connection.driver_class", DatabaseType.MSSQL.getDriverClassName());
        this.setProperty("hibernate.connection.url", url);
        log.warn((Object)String.format("Replaced jTDS JDBC details with Microsoft equivalents: Driver = [%s], URL = [%s]", this.hibernateConfig.getHibernateProperties().getProperty("hibernate.connection.driver_class"), this.hibernateConfig.getHibernateProperties().getProperty("hibernate.connection.url")));
    }

    public String getH2VersionFromConfig() {
        return this.applicationConfig.getProperty((Object)H2_VERSION) != null ? this.applicationConfig.getProperty((Object)H2_VERSION).toString() : OLD_H2_VERSION;
    }

    public boolean resetH2Version() {
        if (CURRENT_H2_VERSION.equals(this.getH2VersionFromConfig())) {
            return false;
        }
        this.setProperty(H2_VERSION, CURRENT_H2_VERSION);
        return true;
    }
}

