/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.setup;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.activemq.util.URISupport;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrokerURIUtils {
    static final String DEFAULT_MAX_INACTVITY_DURATION = "300000";
    private static final List<String> BROKER_PROTOCOLS = Arrays.asList("vm", "tcp", "nio", "ssl", "peer", "udp", "multicast");

    private BrokerURIUtils() {
    }

    @NotNull
    public static URI removeParameter(@NotNull URI brokerURI, @NotNull String paramToRemove) {
        try {
            URI uriToReturn;
            if ("failover".equals(brokerURI.getScheme())) {
                URISupport.CompositeData compositeData = URISupport.parseComposite((URI)brokerURI);
                URI[] components = compositeData.getComponents();
                URI[] decoratedComponents = new URI[components.length];
                for (int i = 0; i < components.length; ++i) {
                    URI component = components[i];
                    decoratedComponents[i] = BrokerURIUtils.removeParameter(component, paramToRemove);
                }
                Map params = compositeData.getParameters();
                params.remove(paramToRemove);
                return BrokerURIUtils.reconstructCompositeUri(brokerURI.getScheme(), compositeData, params, decoratedComponents);
            }
            Map params = URISupport.parseParameters((URI)brokerURI);
            if (params.containsKey(paramToRemove)) {
                params.remove(paramToRemove);
                uriToReturn = URISupport.createRemainingURI((URI)brokerURI, (Map)params);
            } else {
                uriToReturn = brokerURI;
            }
            return uriToReturn;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static URI changeUriIpAddress(@NotNull URI uri, @NotNull String newIpAddress) throws URISyntaxException {
        return new URI(uri.getScheme(), uri.getUserInfo(), newIpAddress, uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
    }

    @NotNull
    public static URI addGlobalFailoverParameters(@NotNull URI brokerURI, @NotNull String failoverParams, @NotNull MergeMode mergeMode) {
        return BrokerURIUtils.addClientBrokerUriParameters(brokerURI, null, failoverParams, mergeMode, null);
    }

    @NotNull
    public static URI addParametersToEachFailoverTransport(@NotNull URI brokerURI, @NotNull String failoverTransportsParams, @NotNull MergeMode mergeMode) {
        return BrokerURIUtils.addClientBrokerUriParameters(brokerURI, failoverTransportsParams, null, mergeMode, null);
    }

    public static URI addParametersToFailoverTransport(@NotNull URI brokerURI, @NotNull String protocol, @NotNull String failoverTransportsParams, @NotNull MergeMode mergeMode) {
        return BrokerURIUtils.addClientBrokerUriParameters(brokerURI, failoverTransportsParams, null, mergeMode, protocol);
    }

    public static Map<String, String> parseQuery(@Nullable String query) throws URISyntaxException {
        return query == null ? Collections.emptyMap() : URISupport.parseQuery((String)query);
    }

    private static URI addClientBrokerUriParameters(@NotNull URI brokerURI, @Nullable String failoverTransportsParamsToAdd, @Nullable String failoverGlobalParamsToAdd, @NotNull MergeMode mergeMode, @Nullable String protocol) {
        try {
            if ("failover".equals(brokerURI.getScheme())) {
                URISupport.CompositeData compositeData = URISupport.parseComposite((URI)brokerURI);
                URI[] failoverTransports = compositeData.getComponents();
                if (StringUtils.isNotBlank((CharSequence)failoverTransportsParamsToAdd)) {
                    for (int i = 0; i < failoverTransports.length; ++i) {
                        URI oldFailOverTransport = failoverTransports[i];
                        if (protocol != null && !StringUtils.equals((CharSequence)protocol, (CharSequence)oldFailOverTransport.getScheme())) continue;
                        Map<String, String> oldParams = BrokerURIUtils.parseQuery(oldFailOverTransport.getQuery());
                        Map<String, String> newParams = BrokerURIUtils.parseQuery(failoverTransportsParamsToAdd);
                        failoverTransports[i] = BrokerURIUtils.createTransportUriWithNewQuery(oldFailOverTransport, BrokerURIUtils.mergeParameterMaps(oldParams, newParams, mergeMode));
                    }
                }
                HashMap<String, String> oldParams = new HashMap<String, String>(compositeData.getParameters());
                Map<String, String> newParams = BrokerURIUtils.parseQuery(failoverGlobalParamsToAdd);
                return BrokerURIUtils.reconstructCompositeUri(brokerURI.getScheme(), compositeData, BrokerURIUtils.mergeParameterMaps(oldParams, newParams, mergeMode), failoverTransports);
            }
            return brokerURI;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<String, String> mergeParameterMaps(Map<String, String> oldParams, Map<String, String> newParams, MergeMode mergeMode) {
        Map<String, String> notPreferred;
        Map<String, String> preferred;
        if (mergeMode == MergeMode.PREFER_NEW_PARAMETERS) {
            preferred = newParams;
            notPreferred = oldParams;
        } else {
            preferred = oldParams;
            notPreferred = newParams;
        }
        HashMap<String, String> map = new HashMap<String, String>(notPreferred);
        map.putAll(preferred);
        return map;
    }

    public static URI decorateBrokerURI(URI brokerURI) {
        String scheme = brokerURI.getScheme();
        try {
            if (BROKER_PROTOCOLS.contains(scheme)) {
                HashMap<String, String> params = new HashMap<String, String>(URISupport.parseParameters((URI)brokerURI));
                if (!params.containsKey("wireFormat.maxInactivityDuration")) {
                    params.put("wireFormat.maxInactivityDuration", DEFAULT_MAX_INACTVITY_DURATION);
                    return BrokerURIUtils.createTransportUriWithNewQuery(brokerURI, params);
                }
            } else if ("failover".equals(scheme)) {
                URISupport.CompositeData compositeData = URISupport.parseComposite((URI)brokerURI);
                URI[] components = compositeData.getComponents();
                URI[] decoratedComponents = new URI[components.length];
                for (int i = 0; i < components.length; ++i) {
                    URI component = components[i];
                    decoratedComponents[i] = BrokerURIUtils.decorateBrokerURI(component);
                }
                return BrokerURIUtils.reconstructCompositeUri(scheme, compositeData, compositeData.getParameters(), decoratedComponents);
            }
        }
        catch (URISyntaxException exception) {
            throw new RuntimeException(exception);
        }
        return brokerURI;
    }

    @NotNull
    public static String generateBrokerClientURI(String brokerConnectionAddress) throws URISyntaxException {
        String brokerConnectionUri = BrokerURIUtils.decorateBrokerURI(new URI(brokerConnectionAddress)).toString();
        return "failover:(" + brokerConnectionUri + ")?" + "maxReconnectAttempts=10&initialReconnectDelay=15000";
    }

    private static URI createTransportUriWithNewQuery(URI uri, Map<String, String> params) throws URISyntaxException {
        return new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), URISupport.createQueryString(params), uri.getFragment());
    }

    private static URI reconstructCompositeUri(String scheme, URISupport.CompositeData compositeData, Map<String, String> mainParameters, URI ... components) throws URISyntaxException {
        String fragment;
        StringBuilder sb = new StringBuilder(scheme);
        sb.append(':');
        String host = compositeData.getHost();
        if (StringUtils.isEmpty((CharSequence)host)) {
            sb.append('(');
            boolean first = true;
            for (URI component : components) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(component);
            }
            sb.append(')');
        } else {
            sb.append(host);
        }
        String path = compositeData.getPath();
        if (path != null) {
            sb.append('/');
            sb.append(path);
        }
        if (!mainParameters.isEmpty()) {
            sb.append("?");
            sb.append(URISupport.createQueryString(mainParameters));
        }
        if ((fragment = compositeData.getFragment()) != null) {
            sb.append("#");
            sb.append(fragment);
        }
        return new URI(sb.toString());
    }

    public static enum MergeMode {
        PREFER_EXISTING_PARAMETERS,
        PREFER_NEW_PARAMETERS;

    }
}

