/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.setup;

import com.atlassian.bamboo.filter.AccessLogFilter;
import com.atlassian.bamboo.plugin.BambooPluginManager;
import com.atlassian.bamboo.plugin.PluginAwareStrutsLocalizedTextProvider;
import com.atlassian.bamboo.setup.BootstrapManager;
import com.atlassian.bamboo.upgrade.tasks.validation.JavaVersionIsSupported;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.util.Version;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.utils.i18n.BambooTextProvider;
import com.atlassian.bamboo.web.utils.JohnsonEventContainerHolder;
import com.atlassian.bamboo.web.utils.ServletContextHolder;
import com.atlassian.bamboo.webwork.StrutsSupport;
import com.atlassian.config.HomeLocator;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.config.XmlJohnsonConfig;
import com.atlassian.johnson.event.Event;
import com.google.common.base.Joiner;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.slf4j.bridge.SLF4JBridgeHandler;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.util.StringUtils;

public class BootstrapLoaderListener
implements ServletContextListener {
    private static final Logger log = Logger.getLogger(BootstrapLoaderListener.class);
    private static final Logger startupLog = Logger.getLogger((String)"com.atlassian.bamboo.lifecycle");
    private static final String OSGI_FRAMEWORK_BOOT_DELEGATION = "atlassian.org.osgi.framework.bootdelegation";
    private final String BOOT_DELEGATION_OVERRIDES = Joiner.on((String)",").join((Object)"javax.servlet", (Object)"javax.servlet.*", new Object[]{"sun.*", "com.sun.*", "org.w3c.dom.*", "org.apache.xerces.*", "org.jboss.byteman.*", "jdk.internal.reflect"});
    private static final String PARAM_BOOTSTRAP_CONTEXT_CONFIG_LOCATION = "bootstrapContextConfigLocation";
    private final String TOMCAT_SERVER_INFO_CLASS_NAME = "org.apache.catalina.util.ServerInfo";

    public void contextInitialized(ServletContextEvent event) {
        log.info((Object)("Starting " + this.getClass().getSimpleName()));
        startupLog.info((Object)"*******************************");
        startupLog.info((Object)"*   Bamboo is starting up     *");
        startupLog.info((Object)"*******************************");
        if (System.getProperty("atlassian.plugins.enable.wait") == null) {
            System.setProperty("atlassian.plugins.enable.wait", "60");
        }
        System.setProperty("com.atlassian.plugin.legacy.wiring.autodetection.mode", "true");
        ServletContext servletContext = event.getServletContext();
        ServletContextHolder.set((ServletContext)servletContext);
        StrutsSupport.initialise();
        this.applyBootDelegationOverride();
        this.applySunDefaultXmlImpl();
        if (BuildUtils.isDevMode()) {
            ConsoleAppender consoleAppender = (ConsoleAppender)Narrow.downTo((Object)LogManager.getRootLogger().getAppender("console"), ConsoleAppender.class);
            if (consoleAppender != null) {
                consoleAppender.setThreshold(null);
                LogManager.getLogger(AccessLogFilter.class).addAppender((Appender)consoleAppender);
            }
            LogManager.getLogger(AccessLogFilter.class).setLevel(Level.DEBUG);
            LogManager.getLogger((String)"org.hibernate.metamodel.internal.MetadataContext").setLevel(Level.INFO);
        }
        JohnsonEventContainer agentJohnson = JohnsonEventContainerHolder.get((ServletContext)servletContext);
        XmlJohnsonConfig johnsonConfig = XmlJohnsonConfig.fromFile((String)"johnson-config.xml");
        try {
            this.configureStrutsResourceBundles(servletContext);
            String[] bootstrapConfigLocations = StringUtils.tokenizeToStringArray((String)servletContext.getInitParameter(PARAM_BOOTSTRAP_CONTEXT_CONFIG_LOCATION), (String)",; \t\n");
            ClassPathXmlApplicationContext bootstrapContext = new ClassPathXmlApplicationContext(bootstrapConfigLocations);
            HomeLocator bambooHomeLocator = (HomeLocator)bootstrapContext.getBean("homeLocator");
            bambooHomeLocator.lookupServletHomeProperty(servletContext);
            BootstrapUtils.setBootstrapContext((ApplicationContext)bootstrapContext);
            String msg = String.format("Starting Bamboo %s (build #%s %s) using Java %s from %s", BuildUtils.getCurrentVersion(), BuildUtils.getCurrentBuildNumber(), BuildUtils.getCurrentBuildDate(), SystemUtils.JAVA_VERSION, SystemUtils.JAVA_VM_VENDOR);
            if (!BuildUtils.isFunctionalTest()) {
                String[] versionArray = JavaVersionIsSupported.parseVersionArray(SystemUtils.JAVA_VERSION);
                Version parsedVersion = JavaVersionIsSupported.parseJavaVersion(versionArray);
                if (!JavaVersionIsSupported.SUPPORTED_VERSIONS.contains(parsedVersion)) {
                    String err = String.format("Unsupported Java version %s detected", SystemUtils.JAVA_VERSION);
                    throw new IllegalStateException(err);
                }
            } else {
                startupLog.info((Object)"Running a functional test, skipping Java version check.");
            }
            startupLog.info((Object)msg);
            String realPath = event.getServletContext().getRealPath("");
            startupLog.info((Object)("Real path of servlet context: " + realPath));
            BootstrapManager bootstrapManager = (BootstrapManager)BootstrapUtils.getBootstrapManager();
            if (bootstrapManager == null) {
                throw new IllegalStateException("Could not initialise bootstrap manager");
            }
            bootstrapManager.init();
            if (!bootstrapManager.isBootstrapped()) {
                agentJohnson.addEvent(new Event(johnsonConfig.getEventType("bootstrap"), "Bamboo bootstrap failed: " + bootstrapManager.getBootstrapFailureReason(), "", johnsonConfig.getEventLevel("fatal")));
            }
            startupLog.info((Object)("Bamboo home directory: " + bootstrapManager.getApplicationHome()));
            startupLog.info((Object)("Default charset: " + Charset.defaultCharset() + ", file name ecoding: " + System.getProperty("sun.jnu.encoding")));
            SLF4JBridgeHandler.removeHandlersForRootLogger();
            SLF4JBridgeHandler.install();
            if (LogManager.getRootLogger().getLevel().equals((Object)Level.DEBUG) && !Boolean.parseBoolean(System.getProperty("bamboo.ignore.debug.logging"))) {
                startupLog.error((Object)"***************************************************************************************************************");
                startupLog.error((Object)"The root log4j logger is set to DEBUG level. This may cause Bamboo to run slowly.");
                startupLog.error((Object)"If you are running Bamboo under JBoss, please read http://confluence.atlassian.com/x/IgdTE");
                startupLog.error((Object)"To disable this error message, start your appserver with the system property -Dbamboo.ignore.debug.logging=true");
                startupLog.error((Object)"***************************************************************************************************************");
            }
            if (bootstrapManager.isSetupComplete() && bootstrapManager.getConfigDirectory() == null) {
                agentJohnson.addEvent(new Event(johnsonConfig.getEventType("bootstrap"), "Bamboo has been setup but the configuration directory cannot be found. Please remove the file from " + bootstrapManager.getApplicationHome() + File.separator + "bamboo.cfg.xml and then restart the application", johnsonConfig.getEventLevel("fatal")));
            }
        }
        catch (Exception e) {
            agentJohnson.addEvent(new Event(johnsonConfig.getEventType("bootstrap"), "Could not load bootstrap from environment", e.toString(), johnsonConfig.getEventLevel("fatal")));
            log.fatal((Object)("An error was encountered while bootstrapping Bamboo (see below): \n" + e.getMessage()), (Throwable)e);
        }
    }

    private void configureStrutsResourceBundles(ServletContext servletContext) {
        ClassLoader webAppClassloader;
        ClassLoader appClassloader = BambooPluginManager.class.getClassLoader();
        if (appClassloader.equals(webAppClassloader = servletContext.getClassLoader())) {
            log.info((Object)"App classloader is the same as web app classloader");
        } else {
            log.info((Object)"More than one main classloader in use, using the Web app classloader to access i18n bundles");
        }
        PluginAwareStrutsLocalizedTextProvider localizedTextProvider = PluginAwareStrutsLocalizedTextProvider.getInstance();
        localizedTextProvider.clearAndAddDefaultResourceBundle("com.atlassian.bamboo.ww2.BambooActionSupport");
        localizedTextProvider.clearAndAddDefaultResourceBundle("com.atlassian.core.AtlassianCore");
        BambooTextProvider.setWebAppClassLoader((ClassLoader)webAppClassloader);
    }

    private void applyBootDelegationOverride() {
        if (this.shouldApplyBootDelegationOverrides()) {
            String existingBootDelegation = System.getProperty(OSGI_FRAMEWORK_BOOT_DELEGATION);
            String newBootDelegation = Joiner.on((String)",").skipNulls().join((Object)existingBootDelegation, (Object)this.BOOT_DELEGATION_OVERRIDES, new Object[0]);
            System.setProperty(OSGI_FRAMEWORK_BOOT_DELEGATION, newBootDelegation);
            startupLog.info((Object)("atlassian.org.osgi.framework.bootdelegation set to " + System.getProperty(OSGI_FRAMEWORK_BOOT_DELEGATION)));
        } else {
            startupLog.info((Object)("atlassian.org.osgi.framework.bootdelegation Override disabled; detected value " + System.getProperty(OSGI_FRAMEWORK_BOOT_DELEGATION)));
        }
    }

    private boolean shouldApplyBootDelegationOverrides() {
        if (SystemProperty.SKIP_BOOT_DELEGATION_OVERRIDES.exists()) {
            boolean skipOverrides = SystemProperty.SKIP_BOOT_DELEGATION_OVERRIDES.getTypedValue();
            startupLog.info((Object)("Boot delegation overrides explicitly configured.  Skip overrides: " + skipOverrides));
            return !skipOverrides;
        }
        try {
            Class<?> serverInfoClass = Class.forName("org.apache.catalina.util.ServerInfo");
            startupLog.debug((Object)"Tomcat detected");
            Object serverInfo = serverInfoClass.newInstance();
            Method getServerInfo = serverInfoClass.getMethod("getServerInfo", new Class[0]);
            Object tomcatVersion = getServerInfo.invoke(serverInfo, new Object[0]);
            startupLog.debug((Object)("Tomcat version: " + tomcatVersion));
            return tomcatVersion.toString().contains("/7") || tomcatVersion.toString().contains("/8");
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return true;
        }
    }

    private boolean isClassAvailable(String className) {
        try {
            return Class.forName(className) != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private void setServiceIfAvailableAndNotSet(String serviceKey, String serviceImpl) {
        String old = System.getProperty(serviceKey);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)old)) {
            if (this.isClassAvailable(serviceImpl)) {
                System.setProperty(serviceKey, serviceImpl);
            } else {
                startupLog.warn((Object)("Could not locate default implementation for " + serviceKey));
            }
        }
    }

    private void applySunDefaultXmlImpl() {
        if (SystemProperty.ENABLE_XML_FACTORY_OVERRIDE.getTypedValue()) {
            this.setServiceIfAvailableAndNotSet("javax.xml.stream.XMLInputFactory", "com.sun.xml.internal.stream.XMLInputFactoryImpl");
            this.setServiceIfAvailableAndNotSet("javax.xml.stream.XMLOutputFactory", "com.sun.xml.internal.stream.XMLOutputFactoryImpl");
            this.setServiceIfAvailableAndNotSet("javax.xml.stream.XMLEventFactory", "com.sun.xml.internal.stream.events.XMLEventFactoryImpl");
            startupLog.info((Object)"XML factory overrides applied");
        } else {
            startupLog.debug((Object)"XML factory overrides disabled");
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        BambooPluginManager.onContextDestroyed();
    }
}

