/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.setup;

import com.atlassian.config.ApplicationConfig;
import com.atlassian.config.ConfigurationException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class BambooApplicationConfig
extends ApplicationConfig {
    private static final Logger log = Logger.getLogger(BambooApplicationConfig.class);
    private volatile String startupBuildNumber;

    public Object getProperty(Object key) {
        String stringValue;
        Object objectValue = super.getProperty(key);
        String applicationHome1 = this.getApplicationHome();
        if (objectValue instanceof String && applicationHome1 != null && StringUtils.contains((CharSequence)(stringValue = (String)objectValue), (CharSequence)"${bambooHome}")) {
            return StringUtils.replace((String)stringValue, (String)"${bambooHome}", (String)applicationHome1);
        }
        return objectValue;
    }

    public Map<String, Object> getPropertiesWithPrefix(String prefix) {
        HashMap<String, Object> newProps = new HashMap<String, Object>();
        TreeMap oldProps = new TreeMap(this.getProperties());
        for (String key : oldProps.keySet()) {
            if (!key.startsWith(prefix)) continue;
            newProps.put(key, this.getProperty(key));
        }
        return newProps;
    }

    public void load() throws ConfigurationException {
        super.load();
        this.startupBuildNumber = this.getBuildNumber();
        this.setSetupComplete(Objects.equals("complete", this.getCurrentSetupStep()));
    }

    @Nullable
    public String getStartupBuildNumber() {
        return this.startupBuildNumber;
    }
}

