/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.setup;

import com.atlassian.bamboo.setup.BrokerURIUtils;
import com.atlassian.bamboo.upgrade.AbstractBootstrapUpgradeTask;
import java.net.URI;
import org.apache.log4j.Logger;

public class AddFailoverParamsClientBrokerUrlUpgradeTask
extends AbstractBootstrapUpgradeTask {
    private static final Logger log = Logger.getLogger(AddFailoverParamsClientBrokerUrlUpgradeTask.class);
    private static final String PROPERTY_TO_ADD = "maxReconnectAttempts=10&initialReconnectDelay=15000";

    public AddFailoverParamsClientBrokerUrlUpgradeTask() {
        super("1302", "Adds maxReconnectAttempts and initialReconnectDelay failover parameters to the broker client URI.");
    }

    public void doUpgrade() throws Exception {
        URI brokerClientURI = this.bootstrapManager.getBrokerClientURI();
        URI newBrokerUrl = BrokerURIUtils.addGlobalFailoverParameters(brokerClientURI, PROPERTY_TO_ADD, BrokerURIUtils.MergeMode.PREFER_NEW_PARAMETERS);
        this.bootstrapManager.setBrokerClientURI(newBrokerUrl);
    }
}

