/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.servlet;

import com.atlassian.bamboo.event.sse.ServerSentEvent;
import com.atlassian.bamboo.event.sse.ServerSentEventQueue;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.servlet.BambooHttpServlet;
import com.google.common.base.Splitter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.acls.Permission;
import org.springframework.beans.factory.annotation.Autowired;

public class ServerSentEventsServlet
extends BambooHttpServlet {
    @Autowired
    private BambooPermissionManager bambooPermissionManager;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (this.bambooPermissionManager.hasGlobalPermission((Permission)BambooPermission.RESTRICTEDADMINISTRATION)) {
            resp.sendError(403);
            return;
        }
        resp.setContentType("text/event-stream");
        resp.setHeader("Cache-Control", "no-cache");
        resp.setCharacterEncoding("UTF-8");
        long sessionId = Long.parseLong(req.getParameter("sessionId"));
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)resp.getOutputStream(), StandardCharsets.UTF_8));
        while (!Thread.currentThread().isInterrupted()) {
            try {
                BlockingQueue events = ServerSentEventQueue.getQueue((long)sessionId);
                ServerSentEvent event = (ServerSentEvent)events.poll(10L, TimeUnit.SECONDS);
                if (event != null) {
                    ServerSentEventsServlet.writeEvents(writer, events, event);
                    continue;
                }
                writer.write("\n");
                writer.flush();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            catch (IOException e) {
                break;
            }
        }
    }

    private static void writeEvents(Writer writer, Queue<ServerSentEvent> events, ServerSentEvent firstEvent) throws IOException {
        ServerSentEvent event;
        ServerSentEventsServlet.writeEvent(writer, firstEvent);
        while ((event = events.poll()) != null) {
            ServerSentEventsServlet.writeEvent(writer, event);
        }
        writer.flush();
    }

    private static void writeEvent(Writer writer, ServerSentEvent event) throws IOException {
        writer.write("event:" + event.getType() + "\n");
        StringBuilder dataBuilder = new StringBuilder();
        Iterator splitStrIterator = Splitter.on((char)'\n').split((CharSequence)event.getData()).iterator();
        while (splitStrIterator.hasNext()) {
            String str = (String)splitStrIterator.next();
            if (str.isEmpty() && !splitStrIterator.hasNext()) continue;
            dataBuilder.append("data:").append(str).append('\n');
        }
        writer.write(dataBuilder.toString() + "\n");
    }
}

