/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.servlet;

import com.atlassian.bamboo.servlet.BambooHttpServlet;
import com.atlassian.bamboo.spring.EventuallyAutowired;
import com.octo.captcha.service.CaptchaServiceException;
import com.octo.captcha.service.image.ImageCaptchaService;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public class BambooCaptchaServlet
extends BambooHttpServlet {
    private static final Logger log = Logger.getLogger(BambooCaptchaServlet.class);
    private static final int MAX_ATTEMPTS = 10;
    @EventuallyAutowired
    private EventuallyAvailable eventuallyAvailable;

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            String captchaId = httpServletRequest.getParameter("atl_token");
            BufferedImage challenge = this.getCaptchaImage(captchaId);
            httpServletResponse.setHeader("Cache-Control", "no-store");
            httpServletResponse.setHeader("Pragma", "no-cache");
            httpServletResponse.setDateHeader("Expires", 0L);
            httpServletResponse.setContentType("image/jpeg");
            ImageIO.write((RenderedImage)challenge, "jpg", (OutputStream)httpServletResponse.getOutputStream());
        }
        catch (IllegalArgumentException e) {
            log.error((Object)"Error encoding CAPTCHA image", (Throwable)e);
            httpServletResponse.sendError(404);
        }
        catch (CaptchaServiceException e) {
            log.error((Object)"Error encoding CAPTCHA image", (Throwable)e);
            httpServletResponse.sendError(500);
        }
    }

    private BufferedImage getCaptchaImage(String captchaId) {
        ImageCaptchaService imageCaptchaService = this.eventuallyAvailable.getImageCaptchaService();
        CaptchaServiceException ex = null;
        for (int i = 0; i != 10; ++i) {
            try {
                return imageCaptchaService.getImageChallengeForID(captchaId, Locale.US);
            }
            catch (CaptchaServiceException e) {
                ex = e;
                continue;
            }
        }
        throw new RuntimeException("10 attempts to generate the captcha failed", ex);
    }

    private static class EventuallyAvailable {
        @Lazy
        @Autowired
        private ImageCaptchaService imageCaptchaService;

        private EventuallyAvailable() {
        }

        @NotNull
        public ImageCaptchaService getImageCaptchaService() {
            return this.imageCaptchaService;
        }
    }
}

