/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security.xsrf;

import com.atlassian.security.random.DefaultSecureTokenGenerator;
import com.atlassian.security.random.SecureTokenGenerator;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XsrfTokenUtils {
    private static final SecureTokenGenerator secureTokenGenerator = DefaultSecureTokenGenerator.getInstance();
    private static final String ATL_TOKEN_SOURCE = "atl_token_source";
    static final String XSRF_TOKEN_KEY = "atl.xsrf.token";

    private XsrfTokenUtils() {
    }

    public static String getTokenFromRequestParameters(HttpServletRequest request) {
        return request.getParameter("atl_token");
    }

    public static String getXsrfTokenSource(HttpServletRequest request) {
        return request.getParameter(ATL_TOKEN_SOURCE);
    }

    @Nullable
    public static String getOrCreateXsrfCookie(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response) {
        Cookie existingCookie;
        String xsrfTokenFromRequest = (String)request.getAttribute(XSRF_TOKEN_KEY);
        if (xsrfTokenFromRequest != null) {
            return xsrfTokenFromRequest;
        }
        String path = request.getContextPath();
        if (StringUtils.isEmpty((CharSequence)path)) {
            path = "/";
        }
        if ((existingCookie = XsrfTokenUtils.getXsrfCookie(request)) != null) {
            if (existingCookie.getSecure() != request.isSecure()) {
                existingCookie.setSecure(request.isSecure());
                existingCookie.setPath(path);
                response.addCookie(existingCookie);
            }
            request.setAttribute(XSRF_TOKEN_KEY, (Object)existingCookie.getValue());
            return existingCookie.getValue();
        }
        String xsrfToken = secureTokenGenerator.generateToken();
        Cookie newCookie = new Cookie(XSRF_TOKEN_KEY, xsrfToken);
        newCookie.setPath(path);
        newCookie.setSecure(request.isSecure());
        response.addCookie(newCookie);
        request.setAttribute(XSRF_TOKEN_KEY, (Object)xsrfToken);
        return null;
    }

    @Nullable
    private static Cookie getXsrfCookie(@NotNull HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!StringUtils.equals((CharSequence)cookie.getName(), (CharSequence)XSRF_TOKEN_KEY)) continue;
            return cookie;
        }
        return null;
    }

    @Nullable
    public static String getXsrfToken(@NotNull HttpServletRequest request) {
        return (String)request.getAttribute(XSRF_TOKEN_KEY);
    }
}

