/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security.acegi.vote;

import com.atlassian.bamboo.security.acegi.acls.HibernateObjectIdentityImpl;
import com.atlassian.bamboo.ww2.aware.permissions.DomainObjectSecurityAware;
import java.util.Iterator;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthorizationServiceException;
import org.acegisecurity.ConfigAttribute;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.vote.AccessDecisionVoter;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class WebworkNewObjectAclVoter
implements AccessDecisionVoter {
    private static final Logger log = Logger.getLogger(WebworkNewObjectAclVoter.class);
    private String processConfigAttribute;

    public WebworkNewObjectAclVoter(String processConfigAttribute) {
        this.processConfigAttribute = processConfigAttribute;
    }

    public int vote(Authentication authentication, Object object, ConfigAttributeDefinition config) {
        Iterator iter = config.getConfigAttributes();
        while (iter.hasNext()) {
            ConfigAttribute attr = (ConfigAttribute)iter.next();
            if (!this.supports(attr)) continue;
            Object domainObject = this.getDomainObjectInstance(object);
            if (domainObject == null) {
                log.info((Object)("Voting to deny - domainObject on " + object + " is null"));
                return -1;
            }
            HibernateObjectIdentityImpl identity = new HibernateObjectIdentityImpl(domainObject);
            if (!identity.getIdentifier().equals(-1L)) continue;
            return 1;
        }
        return -1;
    }

    @Nullable
    private Object getDomainObjectInstance(Object secureObject) {
        if (secureObject instanceof DomainObjectSecurityAware) {
            DomainObjectSecurityAware secured = (DomainObjectSecurityAware)secureObject;
            return secured.getSecuredDomainObject();
        }
        throw new AuthorizationServiceException("Secure object: " + secureObject + " is not a " + DomainObjectSecurityAware.class.getName());
    }

    public boolean supports(Class clazz) {
        return DomainObjectSecurityAware.class.isAssignableFrom(clazz);
    }

    public boolean supports(ConfigAttribute attribute) {
        return attribute.getAttribute() != null && attribute.getAttribute().equals(this.getProcessConfigAttribute());
    }

    public String getProcessConfigAttribute() {
        return this.processConfigAttribute;
    }

    public void setProcessConfigAttribute(String processConfigAttribute) {
        this.processConfigAttribute = processConfigAttribute;
    }
}

