/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security.acegi.vote;

import com.atlassian.bamboo.security.acegi.acls.HibernateObjectIdentityImpl;
import com.atlassian.bamboo.security.acegi.vote.AbstractBambooAclEntryVoter;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.BambooLogger;
import com.atlassian.bamboo.ww2.aware.permissions.DomainObjectSecurityAware;
import java.util.Iterator;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthorizationServiceException;
import org.acegisecurity.ConfigAttribute;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.acls.AclService;
import org.acegisecurity.acls.Permission;
import org.acegisecurity.acls.objectidentity.ObjectIdentity;
import org.codehaus.plexus.util.StringUtils;
import org.jetbrains.annotations.Nullable;

public class WebworkAclVoter
extends AbstractBambooAclEntryVoter {
    private static final BambooLogger log = BambooLogger.getLogger(WebworkAclVoter.class);

    public WebworkAclVoter(AclService aclService, String processConfigAttribute, Permission[] requirePermission) {
        super(aclService, processConfigAttribute, requirePermission);
    }

    @Override
    public int vote(Authentication authentication, Object object, ConfigAttributeDefinition config) {
        Iterator attrIterator = config.getConfigAttributes();
        while (attrIterator.hasNext()) {
            ObjectIdentity objectIdentity;
            HibernateObjectIdentityImpl hibernateObjectIdentity;
            ConfigAttribute attr = (ConfigAttribute)attrIterator.next();
            if (!this.supports(attr)) continue;
            Object domainObject = this.getDomainObjectInstance(object);
            if (domainObject == null) {
                log.info("%s voting to deny access to user '%s' - domainObject on %s is null", new Object[]{this, authentication.getName(), object});
                return -1;
            }
            if (StringUtils.isNotEmpty((String)this.getInternalMethod())) {
                domainObject = this.getInnerDomainObject(domainObject);
            }
            if ((hibernateObjectIdentity = (HibernateObjectIdentityImpl)Narrow.to((Object)(objectIdentity = this.getObjectIdentityRetrievalStrategy().getObjectIdentity(domainObject)), HibernateObjectIdentityImpl.class)) != null) {
                return this.vote(authentication, hibernateObjectIdentity);
            }
            return this.vote(authentication, objectIdentity);
        }
        return 0;
    }

    private int vote(Authentication authentication, HibernateObjectIdentityImpl objectIdentity) {
        int voteResult = this.vote(authentication, (ObjectIdentity)objectIdentity);
        HibernateObjectIdentityImpl ancestorIdentity = objectIdentity.getAncestorIdentity();
        if (ancestorIdentity != null) {
            switch (objectIdentity.getHighestRankPermissionCheckPolicy(this.getRequirePermission())) {
                case AND: {
                    if (voteResult != 1) break;
                    voteResult = this.vote(authentication, ancestorIdentity);
                    break;
                }
                case OR: {
                    if (voteResult != -1) break;
                    voteResult = this.vote(authentication, ancestorIdentity);
                }
            }
        }
        return voteResult;
    }

    @Nullable
    protected Object getDomainObjectInstance(Object secureObject) {
        if (secureObject instanceof DomainObjectSecurityAware) {
            DomainObjectSecurityAware secured = (DomainObjectSecurityAware)secureObject;
            return secured.getSecuredDomainObject();
        }
        throw new AuthorizationServiceException("Secure object: " + secureObject + " is not a " + DomainObjectSecurityAware.class.getName());
    }

    public boolean supports(Class clazz) {
        return DomainObjectSecurityAware.class.isAssignableFrom(clazz);
    }
}

