/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security.acegi.vote;

import com.atlassian.bamboo.chains.cache.ImmutableChainStage;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.project.ProjectIdentifier;
import com.atlassian.bamboo.utils.BambooIterators;
import java.util.Iterator;
import java.util.Optional;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.vote.AccessDecisionVoter;

class VoterUtils {
    private VoterUtils() {
    }

    static boolean supportsAnyConfigAttribute(AccessDecisionVoter voter, ConfigAttributeDefinition config) {
        Iterator attributes = config.getConfigAttributes();
        return BambooIterators.stream((Iterator)attributes).anyMatch(arg_0 -> ((AccessDecisionVoter)voter).supports(arg_0));
    }

    static Optional<ProjectIdentifier> getProjectIdentifierForDomainObject(Object domainObject) {
        if (domainObject instanceof PlanIdentifier) {
            PlanIdentifier planIdentifier = (PlanIdentifier)domainObject;
            return Optional.of(planIdentifier.getProject());
        }
        if (domainObject instanceof ImmutableChainStage) {
            ImmutableChainStage chainStage = (ImmutableChainStage)domainObject;
            return VoterUtils.getProjectIdentifierForDomainObject(chainStage.getChain());
        }
        return Optional.empty();
    }
}

