/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security.acegi.vote;

import com.atlassian.bamboo.project.ProjectIdentifier;
import com.atlassian.bamboo.project.ProjectPlanPermissions;
import com.atlassian.bamboo.security.acegi.vote.VoterUtils;
import com.atlassian.bamboo.security.acegi.vote.WebworkAclVoter;
import com.atlassian.bamboo.utils.BambooIterators;
import com.atlassian.bamboo.ww2.aware.permissions.DomainObjectSecurityAware;
import java.util.Iterator;
import java.util.Optional;
import org.acegisecurity.Authentication;
import org.acegisecurity.ConfigAttribute;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.SecurityConfig;
import org.acegisecurity.acls.AclService;
import org.acegisecurity.acls.Permission;

public class ProjectPlanPermissionAwareWebworkAclVoter
extends WebworkAclVoter {
    public ProjectPlanPermissionAwareWebworkAclVoter(AclService aclService, String processConfigAttribute, Permission[] requirePermission) {
        super(aclService, processConfigAttribute, requirePermission);
    }

    private boolean supportsAny(Iterator<ConfigAttribute> attrs) {
        return BambooIterators.stream(attrs).anyMatch(arg_0 -> ((ProjectPlanPermissionAwareWebworkAclVoter)this).supports(arg_0));
    }

    @Override
    public int vote(Authentication authentication, Object object, ConfigAttributeDefinition config) {
        Optional<ProjectIdentifier> projectIdentifier;
        if (this.supportsAny(config.getConfigAttributes()) && (projectIdentifier = VoterUtils.getProjectIdentifierForDomainObject(this.getDomainObjectInstance(object))).isPresent()) {
            if (this.dontAllowToViewProject(authentication, projectIdentifier::get)) {
                return -1;
            }
            DomainObjectSecurityAware projectPlanPermissionDomainObjectSecurityAware = () -> new ProjectPlanPermissions((ProjectIdentifier)projectIdentifier.get());
            if (this.vote(authentication, projectPlanPermissionDomainObjectSecurityAware, config) == 1) {
                return 1;
            }
        }
        return super.vote(authentication, object, config);
    }

    private boolean dontAllowToViewProject(Authentication authentication, DomainObjectSecurityAware projectDomainObjectSecurityAware) {
        ConfigAttributeDefinition projectConfig = new ConfigAttributeDefinition();
        projectConfig.addConfigAttribute((ConfigAttribute)new SecurityConfig("WW_READ"));
        return this.vote(authentication, projectDomainObjectSecurityAware, projectConfig) == -1;
    }
}

