/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security.acegi.vote;

import com.atlassian.bamboo.project.ProjectIdentifier;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.security.acegi.vote.AbstractBambooAclEntryVoter;
import com.atlassian.bamboo.security.acegi.vote.VoterUtils;
import com.atlassian.bamboo.ww2.aware.permissions.DomainObjectSecurityAware;
import java.util.Optional;
import org.acegisecurity.Authentication;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.acls.AclService;
import org.acegisecurity.acls.Permission;
import org.acegisecurity.vote.AccessDecisionVoter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateInProjectVoter
extends AbstractBambooAclEntryVoter {
    public CreateInProjectVoter(AclService aclService, String processConfigAttribute) {
        super(aclService, processConfigAttribute, new Permission[]{BambooPermission.CREATE});
    }

    @Override
    public int vote(Authentication authentication, Object object, ConfigAttributeDefinition config) {
        Optional<ProjectIdentifier> projectIdentifier;
        if (VoterUtils.supportsAnyConfigAttribute((AccessDecisionVoter)this, config) && (projectIdentifier = VoterUtils.getProjectIdentifierForDomainObject(this.getDomainObjectInstance(object))).isPresent()) {
            int resultVote = super.vote(authentication, projectIdentifier::get, config);
            if (resultVote == 1) {
                return 1;
            }
        }
        return 0;
    }

    @Nullable
    protected Object getDomainObjectInstance(@NotNull Object secureObject) {
        if (secureObject instanceof DomainObjectSecurityAware) {
            DomainObjectSecurityAware secured = (DomainObjectSecurityAware)secureObject;
            return secured.getSecuredDomainObject();
        }
        return super.getDomainObjectInstance(secureObject);
    }
}

