/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security.acegi.vote;

import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.utils.BambooLogger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.Collectors;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthorizationServiceException;
import org.acegisecurity.ConfigAttribute;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.acls.Acl;
import org.acegisecurity.acls.AclService;
import org.acegisecurity.acls.NotFoundException;
import org.acegisecurity.acls.Permission;
import org.acegisecurity.acls.objectidentity.ObjectIdentity;
import org.acegisecurity.acls.objectidentity.ObjectIdentityRetrievalStrategy;
import org.acegisecurity.acls.objectidentity.ObjectIdentityRetrievalStrategyImpl;
import org.acegisecurity.acls.sid.Sid;
import org.acegisecurity.acls.sid.SidRetrievalStrategy;
import org.acegisecurity.acls.sid.SidRetrievalStrategyImpl;
import org.acegisecurity.vote.AclEntryVoter;

public abstract class AbstractBambooAclEntryVoter
extends AclEntryVoter {
    private static final BambooLogger log = BambooLogger.getLogger(AbstractBambooAclEntryVoter.class);
    private final AclService aclService;
    private final Permission[] requirePermission;
    private ObjectIdentityRetrievalStrategy objectIdentityRetrievalStrategy = new ObjectIdentityRetrievalStrategyImpl();
    private SidRetrievalStrategy sidRetrievalStrategy = new SidRetrievalStrategyImpl();

    public AbstractBambooAclEntryVoter(AclService aclService, String processConfigAttribute, Permission[] requirePermission) {
        super(aclService, processConfigAttribute, requirePermission);
        this.aclService = aclService;
        this.requirePermission = requirePermission;
    }

    public int vote(Authentication authentication, Object object, ConfigAttributeDefinition config) {
        Iterator attrIterator = config.getConfigAttributes();
        while (attrIterator.hasNext()) {
            ConfigAttribute attr = (ConfigAttribute)attrIterator.next();
            if (!this.supports(attr)) continue;
            Object domainObject = this.getDomainObjectInstance(object);
            if (domainObject != null && this.getInternalMethod() != null && !"".equals(this.getInternalMethod())) {
                domainObject = this.getInnerDomainObject(domainObject);
            }
            if (domainObject == null) {
                log.debug("%s voting to abstain for %s - domainObject on %s is null", new Object[]{this, authentication.getName(), object});
                return 0;
            }
            ObjectIdentity objectIdentity = this.objectIdentityRetrievalStrategy.getObjectIdentity(domainObject);
            return this.vote(authentication, objectIdentity);
        }
        return 0;
    }

    protected int vote(Authentication authentication, ObjectIdentity objectIdentity) {
        Acl acl;
        Sid[] sids = this.getSidRetrievalStrategy().getSids(authentication);
        try {
            acl = this.aclService.readAclById(objectIdentity, sids);
        }
        catch (NotFoundException nfe) {
            log.debug("%s voting to deny access to user '%s' on %s(%s) - no ACLs apply for this principal", new Object[]{this, authentication.getName(), objectIdentity.getJavaType().getSimpleName(), objectIdentity.getIdentifier()});
            return -1;
        }
        try {
            if (acl.isGranted(this.getRequirePermission(), sids, false)) {
                log.debug("%s voting to grant access to user '%s' on %s(%s)", new Object[]{this, authentication.getName(), objectIdentity.getJavaType().getSimpleName(), objectIdentity.getIdentifier()});
                return 1;
            }
            log.debug("%s voting to deny access to user '%s' on %s(%s) - ACLs returned, but insufficient permissions for this principal", new Object[]{this, authentication.getName(), objectIdentity.getJavaType().getSimpleName(), objectIdentity.getIdentifier()});
            return -1;
        }
        catch (NotFoundException nfe) {
            log.debug("%s voting to deny access to user '%s' on %s(%s) - no ACLs apply for this principal", new Object[]{this, authentication.getName(), objectIdentity.getJavaType().getSimpleName(), objectIdentity.getIdentifier()});
            return -1;
        }
    }

    protected Object getInnerDomainObject(Object domainObject) {
        try {
            Class<?> domainObjectClass = domainObject.getClass();
            Method internalMethod = domainObjectClass.getMethod(this.getInternalMethod(), new Class[0]);
            domainObject = internalMethod.invoke(domainObject, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new AuthorizationServiceException(String.format("Object of class '%s' does not provide the requested internalMethod: %s", domainObject.getClass(), this.getInternalMethod()));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.debug("%s encountered problem invoking internalMethod %s for object: %s", new Object[]{this, this.getInternalMethod(), domainObject});
            log.debug(null, (Throwable)e);
            throw new AuthorizationServiceException("Problem invoking internalMethod: " + this.getInternalMethod() + " for object: " + domainObject);
        }
        return domainObject;
    }

    public AclService getAclService() {
        return this.aclService;
    }

    public Permission[] getRequirePermission() {
        return this.requirePermission;
    }

    public ObjectIdentityRetrievalStrategy getObjectIdentityRetrievalStrategy() {
        return this.objectIdentityRetrievalStrategy;
    }

    public void setObjectIdentityRetrievalStrategy(ObjectIdentityRetrievalStrategy objectIdentityRetrievalStrategy) {
        super.setObjectIdentityRetrievalStrategy(objectIdentityRetrievalStrategy);
        this.objectIdentityRetrievalStrategy = objectIdentityRetrievalStrategy;
    }

    public SidRetrievalStrategy getSidRetrievalStrategy() {
        return this.sidRetrievalStrategy;
    }

    public void setSidRetrievalStrategy(SidRetrievalStrategy sidRetrievalStrategy) {
        super.setSidRetrievalStrategy(sidRetrievalStrategy);
        this.sidRetrievalStrategy = sidRetrievalStrategy;
    }

    public String toString() {
        return String.format("Voter(%s, %s)", this.getProcessConfigAttribute(), Arrays.stream(this.getRequirePermission()).map(permission -> permission instanceof BambooPermission ? ((BambooPermission)permission).getName() : permission.toString()).collect(Collectors.toList()));
    }
}

