/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security.acegi.intercept.web;

import com.atlassian.bamboo.security.acegi.intercept.web.ActionInvocationDefinitionSource;
import com.atlassian.bamboo.ww2.aware.permissions.DomainObjectSecurityAware;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.Interceptor;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.intercept.AbstractSecurityInterceptor;
import org.acegisecurity.intercept.ObjectDefinitionSource;
import org.apache.log4j.Logger;

public class WebworkSecurityInterceptor
extends AbstractSecurityInterceptor
implements Interceptor {
    private static final Logger log = Logger.getLogger(WebworkSecurityInterceptor.class);
    ActionInvocationDefinitionSource objectDefinitionSource;
    private GrantedAuthority[] overrideAuthorities = new GrantedAuthority[0];

    public Class getSecureObjectClass() {
        return DomainObjectSecurityAware.class;
    }

    public ObjectDefinitionSource obtainObjectDefinitionSource() {
        return this.objectDefinitionSource;
    }

    public void destroy() {
    }

    public void init() {
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            for (int i = 0; i < authentication.getAuthorities().length; ++i) {
                for (GrantedAuthority auth : this.overrideAuthorities) {
                    if (!auth.getAuthority().equals(authentication.getAuthorities()[i].getAuthority())) continue;
                    return invocation.invoke();
                }
            }
        }
        super.beforeInvocation(invocation.getAction());
        return invocation.invoke();
    }

    public void setObjectDefinitionSource(ActionInvocationDefinitionSource objectDefinitionSource) {
        this.objectDefinitionSource = objectDefinitionSource;
    }

    public void setOverrideAuthorities(GrantedAuthority[] overrideAuthorities) {
        this.overrideAuthorities = overrideAuthorities;
    }
}

