/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security.acegi.intercept.web;

import com.atlassian.bamboo.security.acegi.intercept.web.ActionInvocationDefinitionSource;
import com.atlassian.bamboo.ww2.aware.permissions.DomainObjectSecurityAware;
import java.beans.PropertyEditorSupport;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.acegisecurity.ConfigAttribute;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.SecurityConfig;
import org.acegisecurity.util.StringSplitUtils;
import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;

public class ActionInvocationDefinitionSourceEditor
extends PropertyEditorSupport {
    private static final Logger log = Logger.getLogger(ActionInvocationDefinitionSourceEditor.class);

    @Override
    public void setAsText(String s) throws IllegalArgumentException {
        ActionInvocationDefinitionSource source = new ActionInvocationDefinitionSource();
        if (s != null && !"".equals(s)) {
            BufferedReader br = new BufferedReader(new StringReader(s));
            while (true) {
                String line;
                try {
                    line = br.readLine();
                }
                catch (IOException ioe) {
                    throw new IllegalArgumentException(ioe.getMessage());
                }
                if (line == null) break;
                if ((line = line.trim()).lastIndexOf(61) == -1) continue;
                if (line.lastIndexOf("==") != -1) {
                    throw new IllegalArgumentException("Only single equals should be used in line " + line);
                }
                String name = StringSplitUtils.substringBeforeLast((String)line, (String)"=");
                String value = StringSplitUtils.substringAfterLast((String)line, (String)"=");
                if (!StringUtils.hasText((String)name) || !StringUtils.hasText((String)value)) {
                    throw new IllegalArgumentException("Failed to parse a valid name/value pair from " + line);
                }
                ConfigAttributeDefinition definition = new ConfigAttributeDefinition();
                String[] tokens = StringUtils.commaDelimitedListToStringArray((String)value);
                for (int i = 0; i < tokens.length; ++i) {
                    definition.addConfigAttribute((ConfigAttribute)new SecurityConfig(tokens[i].trim()));
                }
                try {
                    Class<?> clazz = Class.forName(name, true, Thread.currentThread().getContextClassLoader());
                    if (!DomainObjectSecurityAware.class.isAssignableFrom(clazz)) {
                        throw new IllegalArgumentException("ActionInvocation must be a domian object aware action");
                    }
                    source.addSecuredAction(clazz, definition);
                }
                catch (ClassNotFoundException e) {
                    log.error((Object)e, (Throwable)e);
                    throw new IllegalArgumentException(e);
                }
            }
        }
        this.setValue(source);
    }
}

