/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security.acegi.intercept.web;

import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.ww2.aware.permissions.DomainObjectSecurityAware;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.acegisecurity.ConfigAttribute;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.intercept.ObjectDefinitionSource;
import org.apache.commons.collections4.map.ListOrderedMap;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionInvocationDefinitionSource
implements ObjectDefinitionSource {
    private static final Logger log = Logger.getLogger(ActionInvocationDefinitionSource.class);
    private final Map<Class<? extends DomainObjectSecurityAware>, ConfigAttributeDefinition> interfacesMap = new ListOrderedMap();
    private static final LoadingCache<Class<?>, Map<Class<?>, Integer>> INTERFACES_OF_CLASSES = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, Map<Class<?>, Integer>>(){

        public Map<Class<?>, Integer> load(Class<?> clazz) throws Exception {
            HashMap distances = new HashMap();
            ActionInvocationDefinitionSource.getInterfacesOf(clazz, distances, 0);
            return distances;
        }
    });
    private final LoadingCache<Class<?>, Optional<ConfigAttributeDefinition>> ATTRIBUTES_FOR_CLASS = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, Optional<ConfigAttributeDefinition>>(){

        public Optional<ConfigAttributeDefinition> load(Class<?> clazz) throws Exception {
            return ActionInvocationDefinitionSource.this.lookupAttributes(clazz);
        }
    });

    @Nullable
    public ConfigAttributeDefinition getAttributes(Object object) throws IllegalArgumentException {
        if (object instanceof DomainObjectSecurityAware) {
            return ((Optional)this.ATTRIBUTES_FOR_CLASS.getUnchecked(object.getClass())).orElse(null);
        }
        return null;
    }

    public Iterator<ConfigAttributeDefinition> getConfigAttributeDefinitions() {
        return this.interfacesMap.values().iterator();
    }

    public boolean supports(Class clazz) {
        return ActionInvocationDefinitionSource.supportsClass(clazz);
    }

    private static boolean supportsClass(Class clazz) {
        return DomainObjectSecurityAware.class.isAssignableFrom(clazz);
    }

    public void addSecuredAction(Class<? extends DomainObjectSecurityAware> clazz, ConfigAttributeDefinition definition) {
        this.interfacesMap.put(clazz, definition);
    }

    @NotNull
    private Optional<ConfigAttributeDefinition> lookupAttributes(Class<?> actionClass) {
        ArrayList<Pair<Class<? extends DomainObjectSecurityAware>, ConfigAttributeDefinition>> matches = new ArrayList<Pair<Class<? extends DomainObjectSecurityAware>, ConfigAttributeDefinition>>();
        for (Map.Entry<Class<? extends DomainObjectSecurityAware>, ConfigAttributeDefinition> interfaceAndPermissions : this.interfacesMap.entrySet()) {
            Class<? extends DomainObjectSecurityAware> secureInterface = interfaceAndPermissions.getKey();
            if (!secureInterface.isAssignableFrom(actionClass)) continue;
            Pair match = Pair.make(secureInterface, (Object)interfaceAndPermissions.getValue());
            matches.add(match);
        }
        switch (matches.size()) {
            case 0: {
                return Optional.empty();
            }
            case 1: {
                return Optional.of(((Pair)matches.get((int)0)).second);
            }
        }
        log.debug((Object)("Found " + matches.size() + " interfaces on " + actionClass.getCanonicalName()));
        return Optional.of(this.merge(ActionInvocationDefinitionSource.findAttributesForClosestMatches(actionClass, matches)));
    }

    private ConfigAttributeDefinition merge(Collection<ConfigAttributeDefinition> configAttributeDefinitions) {
        ConfigAttributeDefinition merged = new ConfigAttributeDefinition();
        for (ConfigAttributeDefinition configAttributeDefinition : configAttributeDefinitions) {
            Iterator attribs = configAttributeDefinition.getConfigAttributes();
            while (attribs.hasNext()) {
                merged.addConfigAttribute((ConfigAttribute)attribs.next());
            }
        }
        return merged;
    }

    private static Collection<ConfigAttributeDefinition> findAttributesForClosestMatches(Class<?> clazz, List<Pair<Class<? extends DomainObjectSecurityAware>, ConfigAttributeDefinition>> matches) {
        Map distances = (Map)INTERFACES_OF_CLASSES.getUnchecked(clazz);
        int minDistance = Integer.MAX_VALUE;
        ArrayList<ConfigAttributeDefinition> closestMatches = new ArrayList<ConfigAttributeDefinition>();
        for (Pair<Class<? extends DomainObjectSecurityAware>, ConfigAttributeDefinition> match : matches) {
            Integer matchDistance = (Integer)distances.get(match.first);
            if (matchDistance == null) continue;
            if (matchDistance < minDistance) {
                closestMatches.clear();
                closestMatches.add((ConfigAttributeDefinition)match.second);
                minDistance = matchDistance;
                continue;
            }
            if (matchDistance != minDistance) continue;
            closestMatches.add((ConfigAttributeDefinition)match.second);
        }
        return closestMatches;
    }

    private static void getInterfacesOf(Class<?> clazz, Map<Class<?>, Integer> distances, int depth) {
        Class<?> superclass;
        ArrayList newInterfaces = new ArrayList();
        Class<?>[] interfaces = clazz.getInterfaces();
        if (interfaces.length > 0) {
            for (Class<?> anInterface : interfaces) {
                if (distances.containsKey(anInterface) || !ActionInvocationDefinitionSource.supportsClass(anInterface)) continue;
                newInterfaces.add(anInterface);
                distances.put(anInterface, depth);
            }
        }
        if ((superclass = clazz.getSuperclass()) != null) {
            ActionInvocationDefinitionSource.getInterfacesOf(superclass, distances, depth + 1);
        }
    }
}

