/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security;

import com.atlassian.bamboo.util.BambooStringUtils;
import com.atlassian.seraph.auth.Authenticator;
import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.google.common.collect.ImmutableMap;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.acegisecurity.context.SecurityContextHolder;
import org.codehaus.plexus.util.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogoutSupport {
    private LogoutSupport() {
    }

    public static void logout(@NotNull HttpServletRequest httpServletRequest, @Nullable HttpServletResponse httpServletResponse) throws Exception {
        HttpSession session = httpServletRequest.getSession(false);
        if (session != null) {
            session.invalidate();
        }
        SecurityConfig securityConfig = SecurityConfigFactory.getInstance();
        Authenticator authenticator = securityConfig.getAuthenticator();
        authenticator.logout(httpServletRequest, httpServletResponse);
        SecurityContextHolder.clearContext();
    }

    @Nullable
    public static String getLogoutUrl(String baseUrl, HttpServletRequest request) {
        URL logoutUrl;
        URL requestUrl;
        try {
            requestUrl = new URL(request.getRequestURL().toString());
            SecurityConfig securityConfig = SecurityConfigFactory.getInstance();
            logoutUrl = new URL(baseUrl + LogoutSupport.getCompleteUrlString(securityConfig.getLogoutURL(), request));
        }
        catch (MalformedURLException e) {
            return null;
        }
        if (requestUrl.getPath().startsWith(logoutUrl.getPath())) {
            return null;
        }
        return logoutUrl.toString();
    }

    public static String getCompleteUrlString(String partialUrl, HttpServletRequest request) {
        return BambooStringUtils.formatTemplate((String)partialUrl, (Map)ImmutableMap.of((Object)"originalurl", (Object)StringUtils.defaultString((Object)request.getParameter("os_destination"))));
    }
}

