/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security;

import com.atlassian.bamboo.security.LogoutSupport;
import com.atlassian.bamboo.user.authentication.BambooElevatedSecurityGuard;
import com.atlassian.bamboo.util.RequestCacheThreadLocal;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.GlobalBypassSecurityAware;
import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.seraph.config.SecurityConfigFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.jetbrains.annotations.Nullable;

public class Login
extends BambooActionSupport
implements GlobalBypassSecurityAware {
    @Override
    public String doDefault() throws Exception {
        this.cookieCutter.getValueFromConglomerateCookie("AJS.conglomerate.cookie", "ASDQWE");
        if (this.getLoginUrl() == null) {
            return "input";
        }
        return "login";
    }

    public String execute() throws Exception {
        String bambooAuthStatus;
        String authStatus;
        if (this.isElevatedSecurityFailed()) {
            this.addFieldError("captcha", this.getText("user.captcha.error"));
        }
        if (this.isUserNameTooLong()) {
            this.addActionError(this.getText("user.login.too.long", Collections.singletonList(255)));
        }
        if (StringUtils.isNotEmpty((CharSequence)(authStatus = this.getAuthStatus()))) {
            if (authStatus.equals("failed")) {
                this.addActionError(this.getText("user.login.invalid"));
            }
            if (authStatus.equals("error")) {
                this.addActionError(this.getText("user.login.error"));
            }
            if (authStatus.equals("adminNeeded")) {
                this.addActionError(this.getText("user.login.adminNeeded"));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(bambooAuthStatus = this.getBambooAuthStatus())) && bambooAuthStatus.equals("adminNeeded")) {
            this.addActionError(this.getText("user.login.adminNeeded"));
        }
        return super.execute();
    }

    public boolean isElevatedSecurityRequired() {
        return BambooElevatedSecurityGuard.isElevatedSecurityRequired((ServletRequest)ServletActionContext.getRequest());
    }

    public boolean isElevatedSecurityFailed() {
        return BambooElevatedSecurityGuard.isElevatedSecurityFailed((ServletRequest)ServletActionContext.getRequest());
    }

    private boolean isUserNameTooLong() {
        return BambooElevatedSecurityGuard.isAuthCounterUpdateFailed((ServletRequest)ServletActionContext.getRequest());
    }

    @Nullable
    public String getLoginUrl() {
        URL loginUrl;
        URL requestUrl;
        HttpServletRequest request = RequestCacheThreadLocal.getNonNullRequest();
        try {
            SecurityConfig securityConfig = SecurityConfigFactory.getInstance();
            requestUrl = new URL(request.getRequestURL().toString());
            loginUrl = new URL(this.getBaseUrl() + LogoutSupport.getCompleteUrlString(securityConfig.getLoginURL(), request));
        }
        catch (MalformedURLException e) {
            return null;
        }
        if (requestUrl.getPath().startsWith(loginUrl.getPath())) {
            return null;
        }
        return loginUrl.toString();
    }

    private String getAuthStatus() {
        return (String)ServletActionContext.getRequest().getAttribute("os_authstatus");
    }

    private String getBambooAuthStatus() {
        return (String)ServletActionContext.getRequest().getAttribute("bam_authstatus");
    }
}

