/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security;

import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.mail.BambooMailer;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.GlobalBypassSecurityAware;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.user.User;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class ForgotPassword
extends BambooActionSupport
implements GlobalBypassSecurityAware {
    private static final Logger log = Logger.getLogger(ForgotPassword.class);
    @Autowired
    private MailServerManager mailServerManager;
    @Autowired
    private BambooMailer bambooMailer;
    private String username;
    protected Map<String, Object> context;

    public String input() throws Exception {
        return "input";
    }

    public void validate() {
        if (StringUtils.isNotBlank((CharSequence)this.getUsername())) {
            User user = this.getBambooUserManager().getUser(this.getUsername());
            if (user != null && this.getBambooUserManager().isReadOnly(user)) {
                this.addFieldError("username", this.getText("user.password.change.username.read.only"));
            }
        } else {
            this.addFieldError("username", this.getText("user.password.change.username.empty"));
        }
    }

    public String execute() throws Exception {
        String username = this.getUsername();
        User user = this.getBambooUserManager().getUser(username);
        if (user == null) {
            log.info((Object)("Unknown username was used to restore password: " + username));
            return "success";
        }
        if (!user.isEnabled()) {
            log.info((Object)("Disabled user tried to restore his password - " + username));
            this.addActionError(this.getText("user.password.reset.disabled.user"));
            return "error";
        }
        AdministrationConfiguration adminConfig = this.getAdministrationConfiguration();
        this.context = new HashMap<String, Object>();
        this.context.put("user", user);
        this.context.put("baseUrl", adminConfig.getBaseUrl());
        this.context.put("token", this.getBambooUserManager().createPasswordResetToken(username).getToken());
        ArrayList<String> recipients = new ArrayList<String>();
        recipients.add(user.getEmail());
        try {
            SMTPMailServer mailServer = this.mailServerManager.getDefaultSMTPMailServer();
            if (mailServer == null) {
                this.addActionError(this.getText("user.password.reset.noMail"));
                log.error((Object)"Mail server was not configured, can't send email");
                return "error";
            }
            this.bambooMailer.send("com/atlassian/bamboo/security/ForgotEmail.ftl", this.context, recipients, this.getText("user.password.reset.mail.title"));
        }
        catch (Exception e) {
            String error = this.getText("user.password.reset.error");
            log.error((Object)error, (Throwable)e);
            this.addActionError(error);
            return "error";
        }
        return "success";
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean isMailServerConfigured() {
        return this.mailServerManager.getDefaultSMTPMailServer() != null;
    }
}

