/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security;

import com.atlassian.bamboo.security.LogoutSupport;
import com.atlassian.bamboo.user.LoginInformationManager;
import com.atlassian.bamboo.util.RequestCacheThreadLocal;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.user.User;
import com.google.common.annotations.VisibleForTesting;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ChangePassword
extends BambooActionSupport {
    private String currentPassword;
    private String newPassword;
    private String confirmedPassword;
    @Autowired
    private LoginInformationManager loginInformationManager;

    public boolean validateInput() throws Exception {
        boolean loginThresholdExceeded = false;
        if (StringUtils.isBlank((CharSequence)this.currentPassword)) {
            this.addFieldError("currentPassword", this.getText("user.password.error.required"));
        } else if (!this.getBambooUserManager().authenticate(this.getUsername(), this.currentPassword)) {
            this.addFieldError("currentPassword", this.getText("user.password.change.current.invalid"));
            loginThresholdExceeded = this.loginInformationManager.incrementFailedCountAndCheckThreshold(this.getUsername());
        }
        if (StringUtils.isBlank((CharSequence)this.newPassword)) {
            this.addFieldError("newPassword", this.getText("user.password.change.new.required"));
        } else if (!this.newPassword.equals(this.confirmedPassword)) {
            this.addFieldError("confirmedPassword", this.getText("user.password.change.new.confirm.invalid"));
        }
        return loginThresholdExceeded;
    }

    public String execute() throws Exception {
        boolean loginThresholdExceeded = this.validateInput();
        if (loginThresholdExceeded) {
            LogoutSupport.logout(RequestCacheThreadLocal.getRequest(), RequestCacheThreadLocal.getResponse());
            return "login";
        }
        if (this.hasErrors()) {
            return "error";
        }
        this.getBambooUserManager().alterPassword(this.getBambooUserManager().getUser(this.getUsername()), this.getNewPassword());
        return "success";
    }

    public String getCurrentPassword() {
        return this.currentPassword;
    }

    public void setCurrentPassword(String currentPassword) {
        this.currentPassword = currentPassword;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    public String getConfirmedPassword() {
        return this.confirmedPassword;
    }

    public void setConfirmedPassword(String confirmedPassword) {
        this.confirmedPassword = confirmedPassword;
    }

    private String getUsername() {
        User user = this.getUser();
        if (user == null) {
            return "";
        }
        return user.getName();
    }

    @VisibleForTesting
    protected void setLoginInformationManager(LoginInformationManager loginInformationManager) {
        this.loginInformationManager = loginInformationManager;
    }
}

