/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security;

import com.atlassian.bamboo.user.PasswordResetToken;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.GlobalBypassSecurityAware;
import com.atlassian.core.util.DateUtils;
import com.atlassian.user.User;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ChangeForgottenPassword
extends BambooActionSupport
implements GlobalBypassSecurityAware {
    private static final Logger log = Logger.getLogger(ChangeForgottenPassword.class);
    private String username;
    private String newPassword;
    private String confirmedPassword;
    private String token;

    public void validate() {
        super.validate();
        if (StringUtils.isNotBlank((CharSequence)this.getUsername())) {
            if (this.isValidToken()) {
                if (StringUtils.isBlank((CharSequence)this.newPassword)) {
                    this.addFieldError("newPassword", this.getText("user.password.change.new.required"));
                } else if (!this.newPassword.equals(this.confirmedPassword)) {
                    this.addFieldError("confirmedPassword", this.getText("user.password.change.new.confirm.invalid"));
                }
            }
        } else {
            this.addActionError(this.getText("user.username.error.required"));
        }
    }

    @Override
    public String doDefault() throws Exception {
        if (!this.isValidToken()) {
            return "error";
        }
        return super.doDefault();
    }

    public String execute() throws Exception {
        User user = this.getBambooUserManager().getUser(this.username);
        this.getBambooUserManager().deletePasswordResetToken(this.username);
        this.getBambooUserManager().alterPassword(user, this.getNewPassword());
        return "success";
    }

    private boolean isValidToken() {
        PasswordResetToken userToken = this.getBambooUserManager().getPasswordResetToken(this.getUsername());
        if (userToken == null || !userToken.getToken().equals(this.token)) {
            log.info((Object)("Incorrect username was used to change forgotten password: " + this.getUsername()));
            this.addActionError(this.getText("user.password.reset.token.invalid"));
            return false;
        }
        if (System.currentTimeMillis() - userToken.getTokenCreationTime().getTime() > DateUtils.DAY_MILLIS) {
            this.addActionError(this.getText("user.password.reset.token.expired"));
            return false;
        }
        return true;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    public String getConfirmedPassword() {
        return this.confirmedPassword;
    }

    public void setConfirmedPassword(String confirmedPassword) {
        this.confirmedPassword = confirmedPassword;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }
}

