/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.schedule;

import com.atlassian.core.cron.CronEditorBean;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class BambooCronEditorBean
extends CronEditorBean {
    private static final Logger log = Logger.getLogger(BambooCronEditorBean.class);
    private final List<String> hourOptions = Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"});
    private final List<String> minuteOptions = Lists.newArrayList((Object[])new String[]{"00", "05", "10", "15", "20", "25", "30", "35", "40", "45", "50", "55"});
    private final List<String> meridianOptions = Lists.newArrayList((Object[])new String[]{"am", "pm"});
    private final List<String> availableSchedules = Lists.newArrayList((Object[])new String[]{"daily", "daysOfWeek", "daysOfMonth", "advanced"});
    private final List<String> daysOfWeekOptions = Lists.newArrayList((Object[])new String[]{"1", "5", "2", "6", "3", "7", "4"});
    private final List<String> daysOfMonthOptions = Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "L"});
    private final List<String> weekofMonthOptions = Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4", "L"});
    private final List<String> intervalOptions = Lists.newArrayList((Object[])new String[]{"0", "180", "120", "60", "30", "15"});
    private String dayMinutes;
    private String monthMinutes;
    private String dayHoursRunOnce;
    private String dayHoursRunOnceMeridian;
    private String monthHoursRunOnce;
    private String monthHoursRunOnceMeridian;
    private String checkBoxSpecifiedDaysOfWeek;
    private String monthSpecifiedDaysOfWeek;

    public BambooCronEditorBean(String paramPrefix, Map params) {
        super(paramPrefix, params);
    }

    public BambooCronEditorBean(CronEditorBean cronEditorBean) {
        this.setMode(cronEditorBean.getMode());
        this.setDayHoursRunOnce(cronEditorBean.getHoursRunOnce());
        this.setMonthHoursRunOnce(cronEditorBean.getHoursRunOnce());
        this.setDayHoursRunOnceMeridian(cronEditorBean.getHoursRunOnceMeridian());
        this.setMonthHoursRunOnceMeridian(cronEditorBean.getHoursRunOnceMeridian());
        this.setDayMinutes(cronEditorBean.getMinutes());
        this.setMonthMinutes(cronEditorBean.getMinutes());
        this.setSpecifiedDaysOfWeek(cronEditorBean.getSpecifiedDaysPerWeek());
        this.setCronString(cronEditorBean.getCronString());
        this.setDayInMonthOrdinal(cronEditorBean.getDayInMonthOrdinal());
        this.setDayOfMonth(cronEditorBean.getDayOfMonth());
        this.setDayOfWeekOfMonth(cronEditorBean.getDayOfWeekOfMonth());
        this.setHoursFrom(cronEditorBean.getHoursFrom());
        this.setHoursFromMeridian(cronEditorBean.getHoursFromMeridian());
        this.setHoursTo(cronEditorBean.getHoursTo());
        this.setHoursToMeridian(cronEditorBean.getHoursToMeridian());
        this.setIncrementInMinutes(cronEditorBean.getIncrementInMinutes());
        this.setSeconds(cronEditorBean.getSeconds());
    }

    public String getMinutes() {
        if (this.getMode().equals("daysOfMonth")) {
            return this.monthMinutes;
        }
        return this.dayMinutes;
    }

    public String getDayMinutes() {
        return this.dayMinutes;
    }

    public void setDayMinutes(String dayMinutes) {
        this.dayMinutes = dayMinutes;
    }

    public String getMonthMinutes() {
        return this.monthMinutes;
    }

    public void setMonthMinutes(String monthMinutes) {
        this.monthMinutes = monthMinutes;
    }

    public String getHoursRunOnce() {
        if (this.getMode().equals("daysOfMonth")) {
            return this.monthHoursRunOnce;
        }
        return this.dayHoursRunOnce;
    }

    public String getDayHoursRunOnce() {
        return this.dayHoursRunOnce;
    }

    public void setDayHoursRunOnce(String dayHoursRunOnce) {
        this.dayHoursRunOnce = dayHoursRunOnce;
    }

    public String getMonthHoursRunOnce() {
        return this.monthHoursRunOnce;
    }

    public void setMonthHoursRunOnce(String monthHoursRunOnce) {
        this.monthHoursRunOnce = monthHoursRunOnce;
    }

    public String getHoursRunOnceMeridian() {
        if (this.getMode().equals("daysOfMonth")) {
            return this.monthHoursRunOnceMeridian;
        }
        return this.dayHoursRunOnceMeridian;
    }

    public String getDayHoursRunOnceMeridian() {
        return this.dayHoursRunOnceMeridian;
    }

    public void setDayHoursRunOnceMeridian(String dayHoursRunOnceMeridian) {
        this.dayHoursRunOnceMeridian = dayHoursRunOnceMeridian;
    }

    public String getMonthHoursRunOnceMeridian() {
        return this.monthHoursRunOnceMeridian;
    }

    public void setMonthHoursRunOnceMeridian(String monthHoursRunOnceMeridian) {
        this.monthHoursRunOnceMeridian = monthHoursRunOnceMeridian;
    }

    public String getSpecifiedDaysPerWeek() {
        if (this.getMode().equals("daysOfMonth")) {
            return this.monthSpecifiedDaysOfWeek;
        }
        return this.checkBoxSpecifiedDaysOfWeek;
    }

    public void setCheckBoxSpecifiedDaysOfWeek(String[] checkBoxSpecifiedDaysOfWeek) {
        this.checkBoxSpecifiedDaysOfWeek = StringUtils.join((Object[])checkBoxSpecifiedDaysOfWeek, (String)",");
    }

    public String[] getCheckBoxSpecifiedDaysOfWeek() {
        return StringUtils.split((String)this.checkBoxSpecifiedDaysOfWeek, (String)",");
    }

    public void setSpecifiedDaysOfWeek(String specifiedDaysOfWeek) {
        if (this.getMode().equals("daysOfMonth")) {
            this.monthSpecifiedDaysOfWeek = specifiedDaysOfWeek;
        } else {
            this.checkBoxSpecifiedDaysOfWeek = specifiedDaysOfWeek;
        }
    }

    public String getMonthSpecifiedDaysOfWeek() {
        return this.monthSpecifiedDaysOfWeek;
    }

    public void setMonthSpecifiedDaysOfWeek(String monthSpecifiedDaysOfWeek) {
        this.monthSpecifiedDaysOfWeek = monthSpecifiedDaysOfWeek;
    }

    public boolean isDaySelected(String day) {
        return StringUtils.contains((CharSequence)this.checkBoxSpecifiedDaysOfWeek, (CharSequence)day);
    }

    public List<String> getHourOptions() {
        return this.hourOptions;
    }

    public List<String> getMinuteOptions() {
        return this.minuteOptions;
    }

    public List<String> getMeridianOptions() {
        return this.meridianOptions;
    }

    public List<String> getAvailableSchedules() {
        return this.availableSchedules;
    }

    public List<String> getDaysOfWeek() {
        return this.daysOfWeekOptions;
    }

    public List<String> getDayOptions() {
        return this.daysOfMonthOptions;
    }

    public List<String> getWeekOptions() {
        return this.weekofMonthOptions;
    }

    public List<String> getIntervalOptions() {
        return this.intervalOptions;
    }
}

