/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.rss;

import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.plan.trigger.TriggerManager;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.util.HtmlUtils;
import com.atlassian.bamboo.utils.EscapeChars;
import com.atlassian.bamboo.v2.build.trigger.TriggerReasonRenderer;
import com.google.common.collect.Lists;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class RssFeedBuilder {
    private static final Logger log = Logger.getLogger(RssFeedBuilder.class);
    private static final String RSS_2_0 = "rss_2.0";
    private static final String FEED_TITLE = "Bamboo Build Feed";
    public static final String ONE_LINER_TEMPLATE = "rss-templates/ResultsOneLiner.ftl";
    public static final String CONTENT_TEMPLATE = "rss-templates/ResultsHtmlSummary.ftl";
    private final TemplateRenderer templateRenderer;
    private final TriggerManager triggerManager;
    private final AdministrationConfigurationAccessor administrationConfigurationAccessor;

    public RssFeedBuilder(TemplateRenderer templateRenderer, TriggerManager triggerManager, AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        this.templateRenderer = templateRenderer;
        this.triggerManager = triggerManager;
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
    }

    public SyndFeed createFeed(List<ResultsSummary> resultsList, int maxResults) {
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setFeedType(RSS_2_0);
        feed.setTitle(FEED_TITLE);
        feed.setLink(this.getServerBaseUrl());
        feed.setDescription("A feed of selected build results");
        try {
            ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
            for (int i = 0; i < Math.min(resultsList.size(), maxResults); ++i) {
                ResultsSummary summary = resultsList.get(i);
                SyndEntryImpl entry = new SyndEntryImpl();
                entry.setTitle(this.getOneLineSummary(summary));
                entry.setLink(this.getServerBaseUrl() + this.getBuildUrl(summary));
                entry.setPublishedDate(summary.getBuildCompletedDate());
                SyndContentImpl description = new SyndContentImpl();
                description.setType("text/html");
                description.setValue(this.getResultsAsHtml(summary));
                entry.setDescription((SyndContent)description);
                entries.add(entry);
            }
            feed.setEntries(entries);
        }
        catch (Exception e) {
            log.error((Object)"Failed to update RSS feed", (Throwable)e);
        }
        return feed;
    }

    public SyndFeed createErrorFeed(String errorMessage) {
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setFeedType(RSS_2_0);
        feed.setTitle("Bamboo Build Feed: ERROR");
        feed.setLink(this.getServerBaseUrl());
        feed.setDescription("Rss generation failure");
        SyndEntryImpl entry = new SyndEntryImpl();
        entry.setTitle("RSS Feed generation failed");
        entry.setLink(this.getServerBaseUrl());
        entry.setPublishedDate(new Date());
        SyndContentImpl description = new SyndContentImpl();
        description.setType("text/html");
        description.setValue(errorMessage);
        entry.setDescription((SyndContent)description);
        feed.setEntries((List)Lists.newArrayList((Object[])new SyndEntry[]{entry}));
        return feed;
    }

    private String getOneLineSummary(ResultsSummary resultsSummary) {
        TriggerReasonRenderer reasonRenderer = this.triggerManager.getTriggerReasonRenderer(resultsSummary.getTriggerReason(), resultsSummary);
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("resultsSummary", resultsSummary);
        context.put("triggerReason", reasonRenderer.getShortDescriptionText().trim());
        try {
            return this.templateRenderer.render(ONE_LINER_TEMPLATE, context);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to generate build results one line summary", e);
        }
    }

    private String getResultsAsHtml(ResultsSummary resultsSummary) {
        TriggerReasonRenderer reasonRenderer = this.triggerManager.getTriggerReasonRenderer(resultsSummary.getTriggerReason(), resultsSummary);
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("htmlUtils", HtmlUtils.getInstanceForFreemarker());
        context.put("resultsSummary", resultsSummary);
        context.put("triggerReason", reasonRenderer.getLongDescriptionHtml());
        try {
            return this.templateRenderer.render(CONTENT_TEMPLATE, context);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to generate build results html", e);
        }
    }

    private String getBuildUrl(ResultsSummary resultsSummary) {
        return "/browse/" + EscapeChars.forFormSubmission((String)resultsSummary.getPlanResultKey().getKey());
    }

    private String getServerBaseUrl() {
        AdministrationConfiguration administrationConfiguration = this.administrationConfigurationAccessor.getAdministrationConfiguration();
        return administrationConfiguration.getBaseUrl();
    }
}

