/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.rest;

import com.atlassian.aws.AWSException;
import com.atlassian.bamboo.agent.elastic.server.ElasticFunctionalityFacade;
import com.atlassian.bamboo.rest.AbstractAdminRestAction;
import org.apache.log4j.Logger;

public class StopElasticAgents
extends AbstractAdminRestAction {
    private static final Logger log = Logger.getLogger(StopElasticAgents.class);
    private ElasticFunctionalityFacade elasticFunctionalityFacade;
    private String instanceId;

    public String execute() throws Exception {
        String result = super.execute();
        if (!"success".equals(result)) {
            return result;
        }
        if (this.getInstanceId() == null) {
            this.addActionError("You need to provide instanceId.");
            return "error";
        }
        if (this.instanceId == null) {
            this.addActionError("Could not delete instance, instance id was null");
            log.error((Object)"Could not delete instance, instance id was null");
            return "error";
        }
        try {
            this.elasticFunctionalityFacade.shutdownInstance(this.instanceId);
        }
        catch (AWSException e) {
            log.error((Object)("Error whe shutting down an instance " + this.instanceId), (Throwable)e);
            this.addActionError((Exception)((Object)e));
            return "error";
        }
        return "success";
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public void setElasticFunctionalityFacade(ElasticFunctionalityFacade elasticFunctionalityFacade) {
        this.elasticFunctionalityFacade = elasticFunctionalityFacade;
    }
}

