/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.rest;

import com.atlassian.aws.AWSException;
import com.atlassian.bamboo.agent.elastic.server.ElasticFunctionalityFacade;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfigurationAccessor;
import com.atlassian.bamboo.rest.AbstractAdminRestAction;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class StartElasticAgents
extends AbstractAdminRestAction {
    private String numAgentsToCreate;
    private String elasticImageConfigurationName;
    private ElasticFunctionalityFacade elasticFunctionalityFacade;
    private ElasticImageConfigurationAccessor elasticImageConfigurationAccessor;

    public String execute() throws Exception {
        ElasticImageConfiguration configuration;
        int numAgentsToCreateValue;
        String result = super.execute();
        if (!"success".equals(result)) {
            return result;
        }
        if (this.getNumAgentsToCreate() == null) {
            this.addActionError("You need to provide numAgentsToCreate.");
            return "error";
        }
        try {
            numAgentsToCreateValue = Integer.parseInt(this.getNumAgentsToCreate());
            if (numAgentsToCreateValue <= 0) {
                this.addActionError("Value of numAgentsToCreate is not a positive number.");
                return "error";
            }
        }
        catch (NumberFormatException ex) {
            this.addActionError("Value of numAgentsToCreate is not a positive number.");
            return "error";
        }
        String elasticImageConfigurationName = this.getElasticImageConfigurationName();
        ArrayList<ElasticImageConfiguration> images = new ArrayList<ElasticImageConfiguration>();
        if (StringUtils.isNotBlank((CharSequence)elasticImageConfigurationName)) {
            List elasticImageConfigurationsByName = this.elasticImageConfigurationAccessor.getElasticImageConfigurationsByName(elasticImageConfigurationName, this.getElasticConfig().getRegion());
            configuration = (ElasticImageConfiguration)Iterables.getFirst((Iterable)elasticImageConfigurationsByName, null);
        } else {
            List elasticImageConfigurationsShippedWithBamboo = this.elasticImageConfigurationAccessor.getElasticImageConfigurationsShippedWithBamboo();
            configuration = (ElasticImageConfiguration)Iterables.getFirst((Iterable)elasticImageConfigurationsShippedWithBamboo, null);
        }
        if (configuration != null) {
            for (int i = 0; i < numAgentsToCreateValue; ++i) {
                images.add(configuration);
            }
        } else {
            this.addActionError("Elastic Image Configuration for value of elasticImageConfigurationName not found.");
            return "error";
        }
        try {
            if (!images.isEmpty()) {
                this.elasticFunctionalityFacade.startupAgents(images);
            }
        }
        catch (AWSException ex) {
            this.addActionError((Exception)((Object)ex));
            return "error";
        }
        return "success";
    }

    public String getNumAgentsToCreate() {
        return this.numAgentsToCreate;
    }

    public void setNumAgentsToCreate(String numAgentsToCreate) {
        this.numAgentsToCreate = numAgentsToCreate;
    }

    public String getElasticImageConfigurationName() {
        return this.elasticImageConfigurationName;
    }

    public void setElasticImageConfigurationName(String elasticImageConfigurationName) {
        this.elasticImageConfigurationName = elasticImageConfigurationName;
    }

    public void setElasticFunctionalityFacade(ElasticFunctionalityFacade elasticFunctionalityFacade) {
        this.elasticFunctionalityFacade = elasticFunctionalityFacade;
    }

    public void setElasticImageConfigurationAccessor(ElasticImageConfigurationAccessor elasticImageConfigurationAccessor) {
        this.elasticImageConfigurationAccessor = elasticImageConfigurationAccessor;
    }
}

