/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.rest;

import com.atlassian.bamboo.rest.BambooRemoteException;
import com.atlassian.bamboo.rest.SessionManager;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.GlobalBypassSecurityAware;
import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.seraph.elevatedsecurity.ElevatedSecurityGuard;
import javax.servlet.http.HttpServletRequest;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;

public class Login
extends BambooActionSupport
implements GlobalBypassSecurityAware {
    private String myUsername;
    private String myPassword;
    private String mySessionId;

    public void setUsername(String username) {
        this.myUsername = username;
    }

    public void setPassword(String password) {
        this.myPassword = password;
    }

    public String execute() throws Exception {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if ((StringUtils.isEmpty((CharSequence)this.myUsername) || StringUtils.isEmpty((CharSequence)this.myPassword)) && (authentication == null || "anonymousUser".equals(authentication.getName()))) {
            this.addActionError(this.getText("rest.login.user.and.pass.not.provided"));
            return "error";
        }
        SessionManager sessionManager = this.getBamboo().getSessionManager();
        HttpServletRequest httpServletRequest = ServletActionContext.getRequest();
        ElevatedSecurityGuard securityGuard = this.getElevatedSecurityGuard();
        try {
            if (!securityGuard.performElevatedSecurityCheck(httpServletRequest, this.myUsername)) {
                securityGuard.onFailedLoginAttempt(httpServletRequest, this.myUsername);
                this.addActionError("Attempt to log in user '" + this.myUsername + "' failed. The maximum number of failed login attempts has been reached. Please log into the web\napplication through the web interface to reset the number of failed login attempts.\"");
                return "fourOhThree";
            }
            this.mySessionId = sessionManager.login(this.myUsername, this.myPassword);
            securityGuard.onSuccessfulLoginAttempt(httpServletRequest, this.myUsername);
        }
        catch (BambooRemoteException e) {
            securityGuard.onFailedLoginAttempt(httpServletRequest, this.myUsername);
            this.addActionError((Exception)((Object)e));
            return "error";
        }
        return "success";
    }

    public String getSessionId() {
        return this.mySessionId;
    }

    protected ElevatedSecurityGuard getElevatedSecurityGuard() {
        SecurityConfig securityConfig = (SecurityConfig)ServletActionContext.getServletContext().getAttribute("seraph_config");
        return securityConfig.getElevatedSecurityGuard();
    }
}

