/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.reports.collector;

import com.atlassian.bamboo.reports.collector.LabelUsageRatioCollector;
import com.atlassian.bamboo.reports.collector.RatioOfSuccessCollector;
import com.atlassian.bamboo.reports.collector.ReportCollector;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jfree.data.general.Dataset;
import org.jfree.data.time.TimeTableXYDataset;

public class RatioOfFailureWithLabelUsageCollector
implements ReportCollector {
    private static final Logger log = Logger.getLogger(RatioOfFailureWithLabelUsageCollector.class);
    private static final String LABEL_TARGET_PARAMETER = "labelTarget";
    private ReportCollector ratioOfSuccessCollector = new RatioOfSuccessCollector();
    private ReportCollector labelUsageCollector = new LabelUsageRatioCollector();
    private Map<String, String[]> params;
    private List<? extends ResultsSummary> resultsList;

    @NotNull
    public Dataset getDataset() {
        TimeTableXYDataset combinedDataset = new TimeTableXYDataset();
        TimeTableXYDataset ratioOfSuccessDataset = (TimeTableXYDataset)this.ratioOfSuccessCollector.getDataset();
        TimeTableXYDataset labelUsageDataset = (TimeTableXYDataset)this.labelUsageCollector.getDataset();
        int series = 0;
        for (int i = 0; i < ratioOfSuccessDataset.getItemCount(series); ++i) {
            double successPercent = ratioOfSuccessDataset.getYValue(series, i);
            if (Double.isNaN(successPercent)) {
                successPercent = 0.0;
            }
            combinedDataset.add(ratioOfSuccessDataset.getTimePeriod(i), 100.0 - successPercent, "Failed builds");
            combinedDataset.add(labelUsageDataset.getTimePeriod(i), labelUsageDataset.getYValue(series, i), "Label usage");
        }
        return combinedDataset;
    }

    public void setResultsList(@NotNull List<? extends ResultsSummary> resultsList) {
        this.ratioOfSuccessCollector.setResultsList(resultsList);
        this.labelUsageCollector.setResultsList(resultsList);
        this.resultsList = resultsList;
    }

    public void setParams(@NotNull Map<String, String[]> params) {
        this.ratioOfSuccessCollector.setParams(params);
        this.labelUsageCollector.setParams(params);
        this.params = params;
    }

    public String getPeriodRange() {
        return this.ratioOfSuccessCollector.getPeriodRange();
    }
}

