/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.reports.collector;

import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.charts.collater.TimePeriodAgentUtilizationCollater;
import com.atlassian.bamboo.charts.collater.TimePeriodCollater;
import com.atlassian.bamboo.reports.collector.AbstractTimePeriodCollector;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class AgentUtilizationCollector
extends AbstractTimePeriodCollector {
    private static final Logger log = Logger.getLogger(AgentUtilizationCollector.class);
    private LoadingCache<Long, String> agentNames;

    @Override
    protected String getSeriesKey(@NotNull ResultsSummary summary) {
        return (String)this.agentNames.getUnchecked((Object)summary.getBuildAgentId());
    }

    @Override
    protected TimePeriodCollater getCollater() {
        return new TimePeriodAgentUtilizationCollater();
    }

    public void setAgentManager(final AgentManager agentManager) {
        this.agentNames = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Long, String>(){

            public String load(Long agentId) throws Exception {
                BuildAgent buildAgent = agentManager.getAgent(agentId.longValue());
                return buildAgent != null ? buildAgent.getName() : "Unknown";
            }
        });
    }
}

