/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.reports.collector;

import com.atlassian.bamboo.charts.collater.TimePeriodCollater;
import com.atlassian.bamboo.reports.collector.ReportCollector;
import com.atlassian.bamboo.resultsummary.ResultStatisticsProvider;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.utils.Comparators;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jfree.data.general.Dataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.Month;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimeTableXYDataset;
import org.jfree.data.time.Week;
import org.jfree.data.time.Year;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;

public abstract class AbstractTimePeriodCollector
implements ReportCollector {
    private static final Logger log = Logger.getLogger(AbstractTimePeriodCollector.class);
    List<? extends ResultsSummary> resultsList;
    Map<String, String[]> params;

    protected AbstractTimePeriodCollector() {
    }

    @NotNull
    public Dataset getDataset() {
        HashMap<String, TimePeriodCollater> seriesToPeriodMap = new HashMap<String, TimePeriodCollater>();
        TimeTableXYDataset dataset = new TimeTableXYDataset();
        for (ResultsSummary resultsSummary : this.resultsList) {
            String key = this.getSeriesKey(resultsSummary);
            Date buildDate = resultsSummary.getStatDate();
            TimePeriodCollater collaterForSeries = (TimePeriodCollater)seriesToPeriodMap.get(key);
            if (collaterForSeries == null) {
                collaterForSeries = this.createCollater(this.getPeriod(buildDate, this.getPeriodRange()), key);
                collaterForSeries.addResult((ResultStatisticsProvider)resultsSummary);
                seriesToPeriodMap.put(key, collaterForSeries);
                continue;
            }
            if (this.isInPeriod(collaterForSeries.getPeriod(), buildDate)) {
                collaterForSeries.addResult((ResultStatisticsProvider)resultsSummary);
                continue;
            }
            this.writeCollaterToDataSet(dataset, collaterForSeries);
            RegularTimePeriod nextPeriod = collaterForSeries.getPeriod().next();
            while (!this.isInPeriod(nextPeriod, buildDate)) {
                collaterForSeries = this.createCollater(nextPeriod, key);
                this.writeCollaterToDataSet(dataset, collaterForSeries);
                nextPeriod = nextPeriod.next();
            }
            collaterForSeries = this.createCollater(nextPeriod, key);
            collaterForSeries.addResult((ResultStatisticsProvider)resultsSummary);
            seriesToPeriodMap.put(key, collaterForSeries);
        }
        Collection finalPeriods = seriesToPeriodMap.values();
        for (TimePeriodCollater timePeriodCollater : finalPeriods) {
            this.writeCollaterToDataSet(dataset, timePeriodCollater);
        }
        return dataset;
    }

    protected String getSeriesKey(@NotNull ResultsSummary summary) {
        return summary.getPlanKey().getKey();
    }

    public String getPeriodRange() {
        String[] groupBy;
        String periodRange = "AUTO";
        if (this.params.containsKey("groupByPeriod") && (groupBy = this.params.get("groupByPeriod")) != null && groupBy.length > 0) {
            periodRange = groupBy[0];
        }
        if ("AUTO".equals(periodRange)) {
            ResultsSummary first = this.getResultsList().get(0);
            ResultsSummary last = this.getResultsList().get(this.getResultsList().size() - 1);
            periodRange = this.getAutoDate(first.getStatDate(), last.getStatDate());
        }
        return periodRange;
    }

    protected String getAutoDate(Date startDate, Date lastDate) {
        DateTime start = new DateTime((Object)startDate);
        Interval threeMonths = new Interval((ReadableInstant)start, (ReadablePeriod)Period.months((int)3));
        Interval threeWeeks = new Interval((ReadableInstant)start, (ReadablePeriod)Period.weeks((int)3));
        if (!threeMonths.contains(lastDate.getTime())) {
            return "MONTH";
        }
        if (!threeWeeks.contains(lastDate.getTime())) {
            return "WEEK";
        }
        return "DAY";
    }

    protected RegularTimePeriod getPeriod(Date date, String periodRange) {
        if ("YEAR".equals(periodRange)) {
            return new Year(date);
        }
        if ("WEEK".equals(periodRange)) {
            return new Week(date);
        }
        if ("DAY".equals(periodRange)) {
            return new Day(date);
        }
        if ("MONTH".equals(periodRange)) {
            return new Month(date);
        }
        return new Month(date);
    }

    protected boolean isInPeriod(@Nullable RegularTimePeriod time, Date date) {
        if (time == null) {
            return false;
        }
        long firstMillisecond = time.getFirstMillisecond();
        long lastMillisecond = time.getLastMillisecond();
        long buildTime = date.getTime();
        return buildTime >= firstMillisecond && buildTime <= lastMillisecond;
    }

    protected void writeCollaterToDataSet(TimeTableXYDataset dataset, TimePeriodCollater collater) {
        double value = collater.getValue();
        if (value > 0.0) {
            dataset.add((TimePeriod)collater.getPeriod(), value, collater.getSeriesName());
        } else {
            dataset.add((TimePeriod)collater.getPeriod(), null, collater.getSeriesName(), true);
        }
    }

    protected TimePeriodCollater createCollater(RegularTimePeriod nextPeriod, String key) {
        TimePeriodCollater collaterForSeries = this.getCollater();
        collaterForSeries.setPeriod(nextPeriod);
        collaterForSeries.setSeriesName(key);
        return collaterForSeries;
    }

    protected abstract TimePeriodCollater getCollater();

    public List<? extends ResultsSummary> getResultsList() {
        return this.resultsList;
    }

    public void setResultsList(@NotNull List<? extends ResultsSummary> resultsList) {
        this.resultsList = Comparators.getBuildDateOrdering().sortedCopy(resultsList);
    }

    public Map<String, String[]> getParams() {
        return this.params;
    }

    public void setParams(@NotNull Map<String, String[]> params) {
        this.params = params;
    }
}

