/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.project;

import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.plan.TopLevelPlan;
import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import com.atlassian.bamboo.project.DefaultProject;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.project.ProjectStatusHelper;
import com.atlassian.bamboo.resultsummary.ImmutableResultsSummary;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.opensymphony.xwork2.TextProvider;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ProjectStatusHelperImpl
implements ProjectStatusHelper {
    private static final Logger log = Logger.getLogger(ProjectStatusHelperImpl.class);
    private TextProvider textProvider;
    private final Collection<? extends ImmutableTopLevelPlan> plans;
    private final Multimap<String, ImmutableTopLevelPlan> projectKeyToPlanMap = LinkedHashMultimap.create();

    public ProjectStatusHelperImpl(Collection<? extends ImmutableTopLevelPlan> plans, @NotNull TextProvider textProvider) {
        this.plans = plans;
        for (ImmutableTopLevelPlan immutableTopLevelPlan : this.plans) {
            this.projectKeyToPlanMap.put((Object)immutableTopLevelPlan.getProject().getKey(), (Object)immutableTopLevelPlan);
        }
        this.textProvider = textProvider;
    }

    @Override
    public int getPlanCount(String projectKey) {
        return this.projectKeyToPlanMap.get((Object)projectKey).size();
    }

    @Override
    public int getFailingBuilds(String projectKey) {
        Collection plans = this.projectKeyToPlanMap.get((Object)projectKey);
        int failed = 0;
        for (ImmutableTopLevelPlan build : plans) {
            if (!build.getCurrentStatus().equals("fail")) continue;
            ++failed;
        }
        return failed;
    }

    @Override
    public String getCurrentStatus(String projectKey) {
        return DefaultProject.getCurrentStatusFromPlans((Collection)this.projectKeyToPlanMap.get((Object)projectKey));
    }

    @Override
    public String getProjectSummary(String projectKey) {
        return this.getProjectSummaryForPlans(this.projectKeyToPlanMap.get((Object)projectKey));
    }

    @NotNull
    public Collection<Project> getAllProjects() {
        HashSet<Project> projects = new HashSet<Project>();
        for (ImmutableTopLevelPlan immutableTopLevelPlan : this.plans) {
            projects.add(immutableTopLevelPlan.getProject());
        }
        return projects;
    }

    @Override
    @NotNull
    public Set<Project> getUniqueProjects(Collection<? extends TopLevelPlan> plans) {
        HashSet<Project> projects = new HashSet<Project>();
        for (TopLevelPlan topLevelPlan : plans) {
            projects.add(topLevelPlan.getProject());
        }
        return projects;
    }

    public String getProjectSummaryForPlans(Collection<ImmutableTopLevelPlan> plans) {
        int total = 0;
        int failed = 0;
        int neverRun = 0;
        int disabled = 0;
        int success = 0;
        for (ImmutableTopLevelPlan plan : plans) {
            if (plan.isSuspendedFromBuilding()) {
                ++disabled;
            } else {
                ImmutableResultsSummary summary = plan.getLatestResultsSummary();
                if (summary != null) {
                    if (BuildState.FAILED == summary.getBuildState()) {
                        ++failed;
                    } else if (BuildState.SUCCESS == summary.getBuildState()) {
                        ++success;
                    }
                } else {
                    ++neverRun;
                }
            }
            ++total;
        }
        if (total > 0) {
            if (failed > 0) {
                return this.textProvider.getText("project.status.failed", (List)Lists.newArrayList((Object[])new Integer[]{total, failed}));
            }
            if (success > 0) {
                return this.textProvider.getText("project.status.successful", (List)Lists.newArrayList((Object[])new Integer[]{success}));
            }
            if (neverRun > 0) {
                return this.textProvider.getText("project.status.notRun", (List)Lists.newArrayList((Object[])new Integer[]{neverRun}));
            }
            if (disabled > 0) {
                return this.textProvider.getText("project.status.disabled", (List)Lists.newArrayList((Object[])new Integer[]{disabled}));
            }
        }
        return this.textProvider.getText("project.status.unknown");
    }
}

