/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.web.items;

import com.atlassian.bamboo.DarkFeatureService;
import com.atlassian.bamboo.agent.elastic.server.ElasticFunctionalityFacade;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.bamboo.utils.OptionalNarrow;
import com.atlassian.plugin.web.api.DynamicWebInterfaceManager;
import com.atlassian.plugin.web.api.WebItem;
import com.atlassian.plugin.web.api.WebSection;
import com.atlassian.plugin.web.api.model.WebFragmentBuilder;
import com.atlassian.plugin.web.api.provider.WebItemProvider;
import com.atlassian.struts.TextProvider;
import com.google.common.collect.ImmutableList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.acegisecurity.acls.Permission;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdminMenuCoreLinksProvider
implements WebItemProvider {
    private static final Logger log = Logger.getLogger(AdminMenuCoreLinksProvider.class);
    private static final String ADMIN_MENU_LOCATION = "header.global.secondary/admin.menu/core.links";
    private static final String ADMIN_PANEL_LOCATION = "system.admin";
    private final BambooPermissionManager bambooPermissionManager;
    private final DarkFeatureService darkFeatureService;
    private final DynamicWebInterfaceManager dynamicWebInterfaceManager;
    private final ElasticFunctionalityFacade elasticFunctionalityFacade;
    private final TextProvider textProvider;

    @Inject
    public AdminMenuCoreLinksProvider(BambooPermissionManager bambooPermissionManager, DarkFeatureService darkFeatureService, DynamicWebInterfaceManager dynamicWebInterfaceManager, ElasticFunctionalityFacade elasticFunctionalityFacade, TextProvider textProvider) {
        this.bambooPermissionManager = bambooPermissionManager;
        this.darkFeatureService = darkFeatureService;
        this.dynamicWebInterfaceManager = dynamicWebInterfaceManager;
        this.elasticFunctionalityFacade = elasticFunctionalityFacade;
        this.textProvider = textProvider;
    }

    public Iterable<WebItem> getItems(@NotNull Map<String, Object> context) {
        return this.darkFeatureService.isImprovedAdminPanelNav() ? this.getNewItems(context) : this.getOldItems(context);
    }

    private Iterable<WebItem> getOldItems(@NotNull Map<String, Object> context) {
        ImmutableList.Builder result = ImmutableList.builder();
        String contextPath = this.getContextPath(context);
        if (this.bambooPermissionManager.hasGlobalPermission((Permission)BambooPermission.RESTRICTEDADMINISTRATION)) {
            result.add((Object[])new WebItem[]{this.item(20, "admin", this.textProvider.getText("admin.heading"), contextPath + "/admin/administer.action"), this.item(30, "agentsConfig", this.textProvider.getText("webitems.system.admin.build.agents"), contextPath + "/admin/agent/configureAgents!doDefault.action"), this.item(40, "globalVariablesConfig", this.textProvider.getText("webitems.system.admin.build.globalVariables"), contextPath + "/admin/configureGlobalVariables!doDefault.action"), this.item(60, "userAdmin", this.textProvider.getText("menu.admin.users"), contextPath + "/admin/user/viewUsers.action"), this.item(70, "pluginAdmin", this.textProvider.getText("websections.system.admin.plugins"), contextPath + "/plugins/servlet/upm")});
            if (this.elasticFunctionalityFacade.isElasticSupportEnabled() && this.bambooPermissionManager.canManageElasticBamboo()) {
                result.add((Object)this.item(35, "elasticInstancesAdmin", this.textProvider.getText("menu.admin.elastic.instances"), contextPath + "/admin/elastic/manageElasticInstances.action"));
            }
        }
        if (this.bambooPermissionManager.hasGlobalPermission((Permission)BambooPermission.CREATE_REPOSITORY)) {
            result.add((Object)this.item(50, "linkedRepositoriesConfig", this.textProvider.getText("webitems.system.admin.build.sharedRepositories"), contextPath + "/admin/configureLinkedRepositories!doDefault.action"));
        }
        return result.build();
    }

    private Iterable<WebItem> getNewItems(@NotNull Map<String, Object> context) {
        String idPrefix = "bamboo.global.header.admin.menu-";
        ImmutableList.Builder result = ImmutableList.builder();
        if (this.bambooPermissionManager.hasGlobalPermission((Permission)BambooPermission.RESTRICTEDADMINISTRATION)) {
            this.getWebSections(ADMIN_PANEL_LOCATION, context).map(section -> this.getWebItems((WebSection)section, context).findFirst().map(item -> this.item(section.getWeight(), section.getId() != null ? "bamboo.global.header.admin.menu-" + section.getId() : null, section.getLabel(), item.getUrl()))).filter(Optional::isPresent).map(Optional::get).forEach(arg_0 -> ((ImmutableList.Builder)result).add(arg_0));
        } else if (this.bambooPermissionManager.hasGlobalPermission((Permission)BambooPermission.CREATE_REPOSITORY)) {
            result.add((Object)this.item(50, "linkedRepositoriesConfig", this.textProvider.getText("webitems.system.admin.build.sharedRepositories"), "/admin/configureLinkedRepositories!doDefault.action"));
        }
        return result.build();
    }

    @NotNull
    private WebItem item(int weight, @Nullable String id, @NotNull String label, @Nullable String url) {
        return new WebFragmentBuilder(weight).id(id).label(label).webItem(ADMIN_MENU_LOCATION).url(url).build();
    }

    @NotNull
    private Stream<WebSection> getWebSections(@NotNull String location, @NotNull Map<String, Object> context) {
        try {
            return BambooIterables.stream((Iterable)this.dynamicWebInterfaceManager.getDisplayableWebSections(location, context));
        }
        catch (Exception e) {
            log.warn((Object)("Exception when trying to obtain web sections for location: " + location));
            return Stream.empty();
        }
    }

    @NotNull
    private Stream<WebItem> getWebItems(@NotNull WebSection section, @NotNull Map<String, Object> context) {
        String location = section.getLocation() + '/' + section.getId();
        try {
            return BambooIterables.stream((Iterable)this.dynamicWebInterfaceManager.getDisplayableWebItems(location, context));
        }
        catch (Exception e) {
            log.warn((Object)("Exception when trying to obtain web items for section: " + location));
            return Stream.empty();
        }
    }

    @NotNull
    private String getContextPath(@NotNull Map<String, Object> context) {
        return Optional.ofNullable(context.get("request")).flatMap(OptionalNarrow.downTo(HttpServletRequest.class)).map(HttpServletRequest::getContextPath).orElse("");
    }
}

