/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.web.conditions;

import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plugins.web.conditions.ConditionHelper;
import com.atlassian.bamboo.resultsummary.tests.TestQuarantineManager;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import java.util.Map;

public class HasQuarantinedTestsCondition
implements Condition {
    private TestQuarantineManager testQuarantineManager;
    private CachedPlanManager cachedPlanManager;
    private AdministrationConfigurationAccessor administrationConfigurationAccessor;

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        if (!this.administrationConfigurationAccessor.getAdministrationConfiguration().getQuarantineConfiguration().isEnabled()) {
            return false;
        }
        return ConditionHelper.getPlanKey(context).map(planKey -> (ImmutableChain)this.cachedPlanManager.getPlanByKey(planKey, ImmutableChain.class)).map(this::hasQuarantinedTests).orElse(false);
    }

    private boolean hasQuarantinedTests(ImmutableChain chain) {
        return this.testQuarantineManager.countCurrentlyQuarantinedTests(chain) > 0;
    }

    public void setTestQuarantineManager(TestQuarantineManager testQuarantineManager) {
        this.testQuarantineManager = testQuarantineManager;
    }

    public void setCachedPlanManager(CachedPlanManager cachedPlanManager) {
        this.cachedPlanManager = cachedPlanManager;
    }

    public void setAdministrationConfigurationAccessor(AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
    }
}

