/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.jiraPlugin.actions.ajax;

import com.atlassian.bamboo.build.JiraIssueResultsManager;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plugins.jiraPlugin.actions.ajax.AbstractJiraRelatedAction;
import com.atlassian.bamboo.plugins.jiraPlugin.actions.ajax.ViewBuildResultsByJiraKey;
import com.atlassian.bamboo.resultsummary.ImmutableResultsSummary;
import com.atlassian.bamboo.resultsummary.search.IndexedBuildResultsSearcher;
import com.atlassian.bamboo.utils.Comparators;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ViewPlanStatusByJiraKey
extends AbstractJiraRelatedAction {
    private static final Logger log = Logger.getLogger(ViewBuildResultsByJiraKey.class);
    private Collection<String> planKeys;
    private Long releasedVersionTimestamp;
    private JiraIssueResultsManager jiraIssueResultsManager;
    private IndexedBuildResultsSearcher indexedBuildResultsSearcher;

    public String execute() {
        if (this.planKeys == null) {
            this.planKeys = this.projectKeys != null ? this.jiraIssueResultsManager.findPlanKeysByJiraProjectKeys(this.projectKeys) : (this.jiraIssueKey != null ? this.jiraIssueResultsManager.findPlanKeysByIssueKeys(this.jiraIssueKey) : Collections.emptyList());
        }
        TreeMap<ImmutableChain, ImmutableResultsSummary> planResultMap = new TreeMap<ImmutableChain, ImmutableResultsSummary>((Comparator<ImmutableChain>)Comparators.getTopLevelPlanNameProviderCaseInsensitiveOrdering());
        for (String planKey : this.planKeys) {
            ImmutableChain plan = (ImmutableChain)this.cachedPlanManager.getPlanByKey(PlanKeys.getPlanKey((String)planKey), ImmutableChain.class);
            if (plan != null) {
                ImmutableResultsSummary latestBuildResult = this.findLatestRelevantBuild(plan);
                if (latestBuildResult == null) continue;
                planResultMap.put(plan, latestBuildResult);
                continue;
            }
            log.warn((Object)("Plan '" + planKey + "' not found."));
        }
        this.resultsList = Lists.newArrayList(planResultMap.values());
        return "success";
    }

    @Nullable
    private ImmutableResultsSummary findLatestRelevantBuild(ImmutableChain plan) {
        Object latestBuildResult = this.releasedVersionTimestamp == null ? plan.getLatestResultsSummary() : this.indexedBuildResultsSearcher.findLatestRelevantBuildResult((PlanIdentifier)plan, this.releasedVersionTimestamp);
        return latestBuildResult;
    }

    public Collection<String> getPlanKeys() {
        return this.planKeys;
    }

    public void setPlanKeys(Collection<String> planKeys) {
        this.planKeys = planKeys;
    }

    public void setBuildResultsSearcher(JiraIssueResultsManager jiraIssueResultsManager) {
        this.jiraIssueResultsManager = jiraIssueResultsManager;
    }

    public Long getReleasedVersionTimestamp() {
        return this.releasedVersionTimestamp;
    }

    public void setReleasedVersionTimestamp(Long releasedVersionTimestamp) {
        this.releasedVersionTimestamp = releasedVersionTimestamp;
    }

    public void setIndexedBuildResultsSearcher(IndexedBuildResultsSearcher indexedBuildResultsSearcher) {
        this.indexedBuildResultsSearcher = indexedBuildResultsSearcher;
    }
}

