/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.jiraPlugin.actions;

import com.atlassian.bamboo.applinks.CredentialsRequiredContextException;
import com.atlassian.bamboo.build.FilterController;
import com.atlassian.bamboo.build.JiraIssueResultsManager;
import com.atlassian.bamboo.builder.resultsfilter.AllBuildResultsFilter;
import com.atlassian.bamboo.builder.resultsfilter.BuildResultsFilter;
import com.atlassian.bamboo.builder.resultsfilter.BuildResultsFilterFactory;
import com.atlassian.bamboo.filter.Pager;
import com.atlassian.bamboo.jira.jiraissues.InternalLinkedJiraIssue;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueManager;
import com.atlassian.bamboo.jira.jiraissues.LinkedJiraIssue;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.utils.BambooPredicates;
import com.atlassian.bamboo.ww2.actions.BuildActionSupport;
import com.atlassian.bamboo.ww2.aware.LazyPaginationAware;
import com.atlassian.bamboo.ww2.aware.permissions.PlanReadSecurityAware;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.xwork.ParameterSafe;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ViewJiraIssueForPlan
extends BuildActionSupport
implements LazyPaginationAware<LinkedJiraIssue>,
PlanReadSecurityAware {
    private static final Logger log = Logger.getLogger(ViewJiraIssueForPlan.class);
    private URI credentialsRequiredUrl;
    private List<LinkedJiraIssue> issues;
    private Pager<LinkedJiraIssue> pager;
    private FilterController filterController;
    JiraIssueManager jiraIssueManager;
    private JiraIssueResultsManager jiraIssueResultsManager;
    private BuildResultsFilterFactory buildResultsFilterFactory;

    public String execute() throws Exception {
        if (this.getImmutablePlan() == null) {
            this.addActionError("Could not find the \"" + this.getPlanKey() + "\" plan");
        }
        return this.hasErrors() ? "error" : "success";
    }

    public int getNumberOfRelatedBuilds(String issueKey) {
        return this.jiraIssueResultsManager.getNumberOfRelatedBuildsByIssueKey(Collections.singletonList(issueKey));
    }

    @Override
    public Pager<LinkedJiraIssue> getPager() {
        return this.pager;
    }

    @Override
    public void setPager(Pager<LinkedJiraIssue> pager) {
        this.pager = pager;
    }

    @Override
    @NotNull
    public List<LinkedJiraIssue> getFilteredResultsList(int firstResult, int maxResults) {
        Iterable issuesWithoutDetails = Iterables.limit((Iterable)Iterables.skip(this.getIssues(), (int)firstResult), (int)maxResults);
        try {
            return Lists.newLinkedList((Iterable)this.jiraIssueManager.getJiraIssueDetails(this.getImmutablePlan().getProject(), issuesWithoutDetails));
        }
        catch (CredentialsRequiredContextException e) {
            URI callback = null;
            try {
                callback = new URI(this.getBaseUrl() + this.getCurrentUrl());
            }
            catch (URISyntaxException e1) {
                log.warn((Object)"Cannot establish current URL", (Throwable)e1);
            }
            this.credentialsRequiredUrl = e.getAuthorisationURI(callback);
        }
        catch (ResponseException e) {
            log.error((Object)"Cannot fetch Jira issue details", (Throwable)e);
        }
        return Collections.emptyList();
    }

    @Override
    public int getResultsCount() {
        return this.getIssues().size();
    }

    public boolean requiresOAuthHandshake() {
        return this.credentialsRequiredUrl != null;
    }

    private List<LinkedJiraIssue> getIssues() {
        if (this.issues == null) {
            ImmutablePlan plan = this.getImmutablePlan();
            if (plan == null) {
                this.issues = Collections.emptyList();
            } else {
                List issuesForBuild = new ArrayList();
                BuildResultsFilter filter = this.buildResultsFilterFactory.getInstanceWithCookieKey(this.getFilterController().getSelectedFilterKey());
                if (filter instanceof AllBuildResultsFilter) {
                    issuesForBuild = this.jiraIssueResultsManager.findJiraIssuesForPlanKey(plan.getPlanKey());
                } else {
                    List resultSummaries = filter.getResultsForPlan(plan);
                    if (!resultSummaries.isEmpty()) {
                        issuesForBuild = this.jiraIssueResultsManager.findJiraIssuesForBuildResults(resultSummaries);
                    }
                }
                this.issues = issuesForBuild.stream().filter(BambooPredicates.distinct(InternalLinkedJiraIssue::getIssueKey)).collect(Collectors.toList());
            }
        }
        return this.issues;
    }

    public void setJiraIssueManager(JiraIssueManager jiraIssueManager) {
        this.jiraIssueManager = jiraIssueManager;
    }

    public void setBuildResultsSearcher(JiraIssueResultsManager jiraIssueResultsManager) {
        this.jiraIssueResultsManager = jiraIssueResultsManager;
    }

    @ParameterSafe
    public FilterController getFilterController() {
        return this.filterController;
    }

    public void setFilterController(FilterController filterController) {
        this.filterController = filterController;
    }

    public void setBuildResultsFilterFactory(BuildResultsFilterFactory buildResultsFilterFactory) {
        this.buildResultsFilterFactory = buildResultsFilterFactory;
    }

    public URI getCredentialsRequiredUrl() {
        return this.credentialsRequiredUrl;
    }
}

