/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.jiraPlugin.actions;

import com.atlassian.bamboo.event.ResultsSummaryUpdatedEvent;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueLinkType;
import com.atlassian.bamboo.jira.jiraissues.LinkedJiraIssue;
import com.atlassian.bamboo.jira.jiraissues.LinkedJiraIssueImpl;
import com.atlassian.bamboo.plugins.jiraPlugin.actions.ViewJiraIssues;
import com.atlassian.event.api.EventPublisher;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class EditJiraIssues
extends ViewJiraIssues {
    private static final Logger log = Logger.getLogger(EditJiraIssues.class);
    List<JiraIssueLinkType> availableIssueTypes = new ArrayList<JiraIssueLinkType>(EnumSet.allOf(JiraIssueLinkType.class));
    String currentIssueKey;
    String issueKeyInput;
    String issueTypeInput;
    EventPublisher eventPublisher;

    @Override
    public String doDefault() throws Exception {
        super.execute();
        if (this.getUser() == null) {
            return "error";
        }
        return "input";
    }

    public String execute() throws Exception {
        Iterable keys = this.splitIssueKeyInput(this.issueKeyInput);
        for (String key : keys) {
            LinkedJiraIssueImpl issue = new LinkedJiraIssueImpl();
            issue.setIssueKey(key);
            issue.setResultsSummary(this.resultsSummary);
            if (JiraIssueLinkType.BUILD_FIXES.getLinkType().equals(this.issueTypeInput)) {
                issue.setIssueType(JiraIssueLinkType.BUILD_FIXES);
            } else {
                issue.setIssueType(JiraIssueLinkType.BUILD_RELATES);
            }
            this.resultsSummary.getJiraIssues().add(issue);
            this.resultsSummaryManager.saveResultSummary(this.resultsSummary);
            this.eventPublisher.publish((Object)new ResultsSummaryUpdatedEvent((Object)this, this.resultsSummary.getPlanResultKey(), (Set)Sets.newHashSet((Iterable)keys)));
            this.lastModified = key;
        }
        return "success";
    }

    public void validate() {
        try {
            super.execute();
        }
        catch (Exception e) {
            this.addActionError(e);
        }
        Iterable keys = this.splitIssueKeyInput(this.issueKeyInput);
        if (Iterables.isEmpty((Iterable)keys)) {
            this.addFieldError("issueKeyInput", "Please enter at least one issue key.");
        } else {
            for (String key : keys) {
                if (!this.jiraIssueUtils.isValidIssueKey(key)) {
                    this.addFieldError("issueKeyInput", "\"" + key + "\" is not a valid issue key.");
                    continue;
                }
                if (!this.resultsSummary.getJiraIssueKeys().contains(key)) continue;
                this.addFieldError("issueKeyInput", "The issue key \"" + key + "\" has already been linked to this build result.");
            }
        }
    }

    private Iterable splitIssueKeyInput(String inputString) {
        Splitter onComma = Splitter.on((String)",").trimResults().omitEmptyStrings();
        return Iterables.transform((Iterable)onComma.split((CharSequence)inputString), StringUtils::upperCase);
    }

    public String doDelete() throws Exception {
        HashSet<String> removedIssues = new HashSet<String>();
        Set issues = this.resultsSummary.getJiraIssues();
        for (LinkedJiraIssue issue : issues) {
            if (!issue.getIssueKey().equals(this.currentIssueKey)) continue;
            issues.remove(issue);
            removedIssues.add(issue.getIssueKey());
            break;
        }
        this.resultsSummaryManager.saveResultSummary(this.resultsSummary);
        this.eventPublisher.publish((Object)new ResultsSummaryUpdatedEvent((Object)this, this.resultsSummary.getPlanResultKey(), removedIssues));
        return "success";
    }

    public String getCurrentIssueKey() {
        return this.currentIssueKey;
    }

    public void setCurrentIssueKey(String currentIssueKey) {
        this.currentIssueKey = currentIssueKey;
    }

    public String getIssueKeyInput() {
        return this.issueKeyInput;
    }

    public void setIssueKeyInput(String issueKeyInput) {
        this.issueKeyInput = issueKeyInput;
    }

    public String getIssueTypeInput() {
        return this.issueTypeInput;
    }

    public void setIssueTypeInput(String issueTypeInput) {
        this.issueTypeInput = issueTypeInput;
    }

    public List<JiraIssueLinkType> getAvailableIssueTypes() {
        return this.availableIssueTypes;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }
}

