/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.jiraPlugin;

import com.atlassian.bamboo.applinks.JiraApplinksService;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.user.DefaultAuthenticationContext;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class JiraResultWebItemCondition
implements Condition {
    private JiraApplinksService jiraApplinksService;
    private ResultsSummaryManager resultsSummaryManager;
    private DefaultAuthenticationContext authenticationContext;

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        String buildNumberString;
        String buildKey = StringUtils.defaultString((String)((String)context.get("planKey")), (String)((String)context.get("buildKey")));
        String string = buildNumberString = context.get("buildNumber") != null ? (String)context.get("buildNumber") : null;
        if (buildKey != null && buildNumberString != null) {
            try {
                int buildNumber = Integer.parseInt(buildNumberString);
                ResultsSummary buildResults = this.resultsSummaryManager.getResultsSummary(PlanKeys.getPlanResultKey((String)buildKey, (int)buildNumber));
                if (buildResults != null && (buildResults.getJiraIssues() == null || buildResults.getJiraIssues().isEmpty()) && this.authenticationContext.getUser() == null) {
                    return false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.jiraApplinksService.hasJiraApplicationLink();
    }

    public void setJiraApplinksService(JiraApplinksService jiraApplinksService) {
        this.jiraApplinksService = jiraApplinksService;
    }

    public void setAuthenticationContext(DefaultAuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    public void setResultsSummaryManager(ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
    }
}

