/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.webresource;

import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.bamboo.util.RequestCacheThreadLocal;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.utils.i18n.I18nBeanFactory;
import com.atlassian.cache.CacheFactory;
import com.atlassian.config.HomeLocator;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.cdn.CDNStrategy;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class BambooWebResourceIntegration
implements WebResourceIntegration {
    @Autowired
    private CacheFactory cacheFactory;
    @Autowired
    private HomeLocator homeLocator;
    @Autowired
    private I18nBeanFactory i18nBeanFactory;
    @Autowired
    private PluginAccessor pluginAccessor;
    @Autowired
    private PluginEventManager pluginEventManager;
    private final String superBatchVersion;
    private static final AtomicInteger systemCounter = new AtomicInteger(1);

    public BambooWebResourceIntegration(String superBatchVersion) {
        this.superBatchVersion = superBatchVersion;
    }

    public PluginAccessor getPluginAccessor() {
        return this.pluginAccessor;
    }

    public Map<String, Object> getRequestCache() {
        return RequestCacheThreadLocal.getRequestCache();
    }

    public String getSystemCounter() {
        if (new SystemProperty.BooleanSystemProperty(false, false, new String[]{"atlassian.disable.caches"}).getTypedValue()) {
            return String.valueOf(this.getAdministrationConfiguration().incrementAndGetWebResourcesSystemCounter());
        }
        return String.valueOf(this.getAdministrationConfiguration().getWebResourcesSystemCounter());
    }

    public String getSystemBuildNumber() {
        return BuildUtils.getCurrentBuildNumber();
    }

    public String getBaseUrl() {
        return this.getBaseUrl(UrlMode.AUTO);
    }

    public String getBaseUrl(UrlMode urlMode) {
        switch (urlMode) {
            case AUTO: 
            case RELATIVE: {
                String contextPath = RequestCacheThreadLocal.getContextPath();
                if (contextPath != null) {
                    return contextPath;
                }
            }
            case ABSOLUTE: {
                return this.getAdministrationConfiguration().getBaseUrl();
            }
        }
        throw new AssertionError((Object)("Unsupported URLMode: " + urlMode));
    }

    public String getSuperBatchVersion() {
        return this.superBatchVersion;
    }

    public File getTemporaryDirectory() {
        return new File(this.homeLocator.getHomePath(), "temp" + File.separator + "webresources");
    }

    public Set<String> allowedCondition1Keys() {
        return ImmutableSet.builder().add((Object)"com.atlassian.applinks.applinks-plugin:list-application-links-agent").add((Object)"com.atlassian.plugins.atlassian-nav-links-plugin:administration-shortcuts").build();
    }

    public Set<String> allowedTransform1Keys() {
        return ImmutableSet.builder().add((Object)"com.atlassian.gadgets.publisher:ajs-gadgets-lite").add((Object)"com.atlassian.gadgets.publisher:ajs-gadgets").build();
    }

    public boolean forbidCondition1AndTransformer1() {
        return false;
    }

    public AdministrationConfiguration getAdministrationConfiguration() {
        return (AdministrationConfiguration)ContainerManager.getComponent((String)"administrationConfiguration");
    }

    public String getStaticResourceLocale() {
        return this.i18nBeanFactory.getI18nBean().getLocale().toString();
    }

    public CDNStrategy getCDNStrategy() {
        return null;
    }

    public Locale getLocale() {
        return this.i18nBeanFactory.getI18nBean().getLocale();
    }

    @NotNull
    public String getI18nRawText(Locale locale, String s) {
        String i18nRawText = this.i18nBeanFactory.getI18nBean(locale).getI18nRawText(s);
        if (i18nRawText == null) {
            return s;
        }
        return i18nRawText;
    }

    public String getI18nText(Locale locale, String s) {
        return this.i18nBeanFactory.getI18nBean(locale).getText(s);
    }

    public PluginEventManager getPluginEventManager() {
        return this.pluginEventManager;
    }

    public String getHostApplicationVersion() {
        return BuildUtils.getCurrentVersion();
    }

    public String getI18nStateHash() {
        return null;
    }

    public Iterable<Locale> getSupportedLocales() {
        return Collections.singleton(this.getLocale());
    }
}

