/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.sitemesh;

import com.atlassian.bamboo.plugin.descriptor.DecoratorMapperModuleDescriptor;
import com.atlassian.bamboo.plugin.descriptor.DecoratorModuleDescriptor;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.spring.container.ContainerManager;
import com.opensymphony.module.sitemesh.Decorator;
import com.opensymphony.module.sitemesh.DecoratorMapper;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.mapper.AbstractDecoratorMapper;
import com.opensymphony.module.sitemesh.mapper.DefaultDecorator;
import java.util.List;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class PluginDecoratorMapper
extends AbstractDecoratorMapper {
    private static final Logger log = Logger.getLogger(PluginDecoratorMapper.class);

    public Decorator getDecorator(HttpServletRequest request, Page page) {
        PluginAccessor pluginAccessor = this.getPluginAccessor();
        if (pluginAccessor != null) {
            Decorator decorator = this.getDecoratorFromPluginMappers(request, page, pluginAccessor);
            if (decorator != null) {
                return decorator;
            }
            decorator = this.getDecoratorFromPluginDecorators(request, pluginAccessor);
            if (decorator != null) {
                return decorator;
            }
        }
        return super.getDecorator(request, page);
    }

    private Decorator getDecoratorFromPluginDecorators(HttpServletRequest request, PluginAccessor pluginAccessor) {
        List decoratorModuleDescriptors = pluginAccessor.getEnabledModuleDescriptorsByClass(DecoratorModuleDescriptor.class);
        for (DecoratorModuleDescriptor desc : decoratorModuleDescriptors) {
            Decorator namedDecorator;
            String fullPath;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Trying decorator " + desc.getCompleteKey() + " on servlet path " + request.getServletPath()));
            }
            if (desc.getPattern() == null) continue;
            String string = fullPath = request.getPathInfo() != null ? request.getServletPath() + request.getPathInfo() : request.getServletPath();
            Matcher matcher = desc.getPattern().matcher(fullPath);
            if (!matcher.matches()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Matched decorator plugin with key %s on path %s using expression %s. Decorating with page %s.", desc.getCompleteKey(), fullPath, desc.getPattern(), desc.getPage()));
            }
            return (namedDecorator = super.getNamedDecorator(request, desc.getPage())) != null ? namedDecorator : this.createDefaultDecorator(desc);
        }
        return null;
    }

    private Decorator getDecoratorFromPluginMappers(HttpServletRequest request, Page page, PluginAccessor pluginAccessor) {
        List decoratorMapperModuleDescriptors = pluginAccessor.getEnabledModuleDescriptorsByClass(DecoratorMapperModuleDescriptor.class);
        for (DecoratorMapperModuleDescriptor desc : decoratorMapperModuleDescriptors) {
            DecoratorMapper decoratorMapper;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Trying mapper " + desc.getCompleteKey() + " on servlet path " + request.getServletPath()));
            }
            if ((decoratorMapper = desc.getDecoratorMapper(this.config)) != null) {
                Decorator decorator = decoratorMapper.getDecorator(request, page);
                if (decorator == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Matched decorator mapper plugin with key " + desc.getCompleteKey() + " on path " + request.getServletPath() + ". Returning decorator named " + decorator.getName()));
                }
                return decorator;
            }
            log.warn((Object)("Decorator mapper null: " + desc.getCompleteKey()));
        }
        return null;
    }

    public Decorator getNamedDecorator(HttpServletRequest request, String name) {
        PluginAccessor pluginAccessor = this.getPluginAccessor();
        if (pluginAccessor != null) {
            List decoratorMapperModuleDescriptors = pluginAccessor.getEnabledModuleDescriptorsByClass(DecoratorMapperModuleDescriptor.class);
            for (DecoratorMapperModuleDescriptor desc : decoratorMapperModuleDescriptors) {
                DecoratorMapper decoratorMapper = desc.getDecoratorMapper(this.config);
                if (decoratorMapper != null) {
                    Decorator decorator = decoratorMapper.getNamedDecorator(request, name);
                    if (decorator == null) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Decorator mapper " + desc.getCompleteKey() + " returned decorator for name " + name));
                    }
                    return decorator;
                }
                log.warn((Object)("Decorator mapper null: " + desc.getCompleteKey()));
            }
            for (DecoratorMapperModuleDescriptor desc : pluginAccessor.getEnabledModuleDescriptorsByClass(DecoratorModuleDescriptor.class)) {
                if (!name.equals(desc.getName())) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Decorator " + desc.getCompleteKey() + " matched name " + name));
                }
                return this.createDefaultDecorator((DecoratorModuleDescriptor)desc);
            }
        }
        return super.getNamedDecorator(request, name);
    }

    private Decorator createDefaultDecorator(DecoratorModuleDescriptor desc) {
        return new DefaultDecorator(desc.getName(), desc.getPage(), null);
    }

    PluginAccessor getPluginAccessor() {
        if (BootstrapUtils.getBootstrapManager() != null && BootstrapUtils.getBootstrapManager().isSetupComplete()) {
            return (PluginAccessor)ContainerManager.getComponent((String)"pluginAccessor");
        }
        return null;
    }
}

