/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.ImmutableResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultSummaryHelper;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.tests.TestResultsSummary;
import com.atlassian.bamboo.v2.build.trigger.TriggerReason;
import com.opensymphony.xwork2.TextProvider;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ResultsSummaryJsonDecorator {
    private static final Logger log = Logger.getLogger(ResultsSummaryJsonDecorator.class);
    protected String buildStatus;
    protected String planKey;
    protected int buildNumber;
    protected String buildStatusDescription;
    protected String trigger;
    protected int newFailedTestCaseCount;
    protected int existingFailedTestCaseCount;
    protected boolean specsFailure;
    protected boolean specsSuccess;
    protected boolean active;
    protected boolean rebuild;
    protected boolean onceOff;
    protected boolean customBuild;
    protected TriggerReason triggerReason;

    public ResultsSummaryJsonDecorator(@NotNull TextProvider textProvider, ResultsSummary resultsSummary, ImmutablePlan plan) {
        this.buildStatus = this.getPlanStatusIcon(resultsSummary);
        this.buildStatusDescription = textProvider.getText(resultsSummary.isFinished() ? "build.buildState." + resultsSummary.getBuildState().name() : "build.lifeCycleState." + resultsSummary.getLifeCycleState().name());
        this.buildNumber = resultsSummary.getBuildNumber();
        this.planKey = plan.getKey();
        this.trigger = resultsSummary.getReasonSummary();
        if (resultsSummary.isFailed()) {
            TestResultsSummary testResultSummary = resultsSummary.getTestResultsSummary();
            this.newFailedTestCaseCount = testResultSummary.getNewFailedTestCaseCount();
            this.existingFailedTestCaseCount = testResultSummary.getExistingFailedTestCount();
            this.specsFailure = ResultSummaryHelper.isBambooSpecFailure((ImmutableResultsSummary)resultsSummary);
        } else {
            this.specsSuccess = ResultSummaryHelper.isBambooSpecSuccess((ImmutableResultsSummary)resultsSummary);
        }
        this.active = resultsSummary.isActive();
        this.rebuild = resultsSummary.isRebuild();
        this.onceOff = resultsSummary.isOnceOff();
        this.customBuild = resultsSummary.isCustomBuild();
        this.triggerReason = resultsSummary.getTriggerReason();
    }

    @NotNull
    protected Map<String, Object> getMap() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("buildStatus", this.buildStatus);
        data.put("buildStatusDescription", this.buildStatusDescription);
        data.put("planKey", this.planKey);
        data.put("buildNumber", this.buildNumber);
        data.put("trigger", this.trigger);
        data.put("active", this.active);
        data.put("newFailedTestCaseCount", this.newFailedTestCaseCount);
        data.put("existingFailedTestCaseCount", this.existingFailedTestCaseCount);
        data.put("specsFailure", this.specsFailure);
        data.put("specsSuccess", this.specsSuccess);
        data.put("rebuild", this.rebuild);
        data.put("onceOff", this.onceOff);
        data.put("customBuild", this.customBuild);
        data.put("triggerReason", this.triggerReason.getName());
        return data;
    }

    protected String getPlanStatusIcon(ResultsSummary resultsSummary) {
        if (resultsSummary instanceof ChainResultsSummary && ((ChainResultsSummary)resultsSummary).isContinuable() && resultsSummary.getBuildState().equals((Object)BuildState.SUCCESS)) {
            return "SuccessfulPartial";
        }
        if (resultsSummary.isNotRunYet()) {
            return "NotRunYet";
        }
        if (resultsSummary.isFinished()) {
            return resultsSummary.getBuildState().toString();
        }
        return resultsSummary.getLifeCycleState().toString();
    }
}

