/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.ResultsSummaryJsonDecorator;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.google.common.collect.Sets;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import com.opensymphony.xwork2.TextProvider;
import io.atlassian.util.concurrent.Lazy;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlanStatusHistoryAction
extends BambooActionSupport {
    private static final Logger log = Logger.getLogger(PlanStatusHistoryAction.class);
    private static final int MAX_RESULTS = 10;
    private List<ResultsSummary> navigableSummaries;
    private PlanKey planKey;
    @Nullable
    private PlanKey jobKey;
    @Nullable
    private Integer buildNumber;
    @Nullable
    private String scanDirection;
    private TextProvider textProvider;
    private ResultsSummaryManager resultsSummaryManager;
    private final Supplier<List<Map<String, Object>>> navigableBuilds = Lazy.supplier(() -> this.getNavigableSummaries().stream().map(rs -> new ResultsSummaryJsonDecorator(this.textProvider, (ResultsSummary)rs, (ImmutablePlan)this.getPlan()).getMap()).collect(Collectors.toList()));
    private final Supplier<ImmutableChain> plan = Lazy.supplier(() -> {
        Class<ImmutableChain> planType = ImmutableChain.class;
        if (this.planKey != null) {
            ImmutableChain plan = (ImmutableChain)this.cachedPlanManager.getPlanByKeyIfOfType(this.planKey, planType);
            if (plan == null) {
                log.warn((Object)String.format("No plan found of type %s with key %s", planType.getSimpleName(), this.planKey.getKey()));
            }
            return plan;
        }
        log.warn((Object)String.format("Plan key was null when attempted to get a plan of type %s", planType.getSimpleName()));
        return null;
    });

    @Override
    @Nullable
    public Object getSecuredDomainObject() {
        return this.getPlan();
    }

    public String list() {
        return this.planKey != null ? "success" : "error";
    }

    @Override
    @NotNull
    public JSONObject getJsonObject() throws JSONException {
        JSONObject jsonObject = super.getJsonObject();
        jsonObject.put(this.getNavigableSummariesKey(), this.getNavigableBuilds());
        return jsonObject;
    }

    public List<Map<String, Object>> getNavigableBuilds() {
        return this.navigableBuilds.get();
    }

    @NotNull
    private List<ResultsSummary> getNavigableSummaries() {
        if (this.navigableSummaries == null) {
            ImmutableChain plan = this.getPlan();
            if (plan == null) {
                this.navigableSummaries = Collections.emptyList();
            } else {
                List<ResultsSummary> results = this.buildNumber == null ? this.getNavigableSummariesBefore(plan, Integer.MAX_VALUE, 10) : ("before".equalsIgnoreCase(this.scanDirection) ? this.getNavigableSummariesBefore(plan, this.buildNumber, 10) : ("after".equalsIgnoreCase(this.scanDirection) ? this.getNavigableSummariesAfter(plan, this.buildNumber, 10) : this.getNavigableSummariesAround(plan, this.buildNumber, 10)));
                this.navigableSummaries = results;
            }
        }
        return this.navigableSummaries;
    }

    @NotNull
    private List<ResultsSummary> getNavigableSummariesBefore(ImmutableChain plan, int relativeBuildNumber, int maxResults) {
        HashSet beforeSet = Sets.newHashSet((Iterable)this.resultsSummaryManager.getBeforeSummaries((ImmutablePlan)plan, relativeBuildNumber, maxResults));
        return Comparators.getResultsSummaryNumberOrdering().sortedCopy((Iterable)beforeSet);
    }

    @NotNull
    private List<ResultsSummary> getNavigableSummariesAfter(ImmutableChain plan, int relativeBuildNumber, int maxResults) {
        HashSet afterSet = Sets.newHashSet((Iterable)this.resultsSummaryManager.getAfterSummaries((ImmutablePlan)plan, relativeBuildNumber, maxResults));
        return Comparators.getResultsSummaryNumberOrdering().sortedCopy((Iterable)afterSet);
    }

    @NotNull
    private List<ResultsSummary> getNavigableSummariesAround(ImmutableChain plan, int relativeBuildNumber, int maxResults) {
        HashSet neighbouringSet = Sets.newHashSet((Iterable)this.resultsSummaryManager.getNeighbouringSummaries((ImmutablePlan)plan, relativeBuildNumber, maxResults));
        return Comparators.getResultsSummaryNumberOrdering().sortedCopy((Iterable)neighbouringSet);
    }

    @Nullable
    public ResultsSummary findLastBuildResultBefore(@NotNull String buildKey, int buildNumber) {
        return this.resultsSummaryManager.findLastBuildResultBefore(buildKey, buildNumber);
    }

    @Nullable
    public ImmutableChain getPlan() {
        return this.plan.get();
    }

    public PlanKey getPlanKey() {
        return this.planKey;
    }

    public void setPlanKey(PlanKey planKey) {
        if (PlanKeys.isJobKey((PlanKey)planKey)) {
            this.planKey = PlanKeys.getChainKeyIfJobKey((PlanKey)planKey);
            this.jobKey = planKey;
        } else {
            this.planKey = planKey;
        }
    }

    @Nullable
    public PlanKey getJobKey() {
        return this.jobKey;
    }

    public void setBuildKey(String buildKey) {
        this.setPlanKey(PlanKeys.getPlanKey((String)buildKey));
    }

    public String getNavigableSummariesKey() {
        return "navigableSummaries";
    }

    @Nullable
    public Integer getBuildNumber() {
        return this.buildNumber;
    }

    public void setBuildNumber(@Nullable Integer buildNumber) {
        this.buildNumber = buildNumber;
    }

    @Nullable
    public String getScanDirection() {
        return this.scanDirection;
    }

    public void setScanDirection(@Nullable String scanDirection) {
        this.scanDirection = scanDirection;
    }

    public void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
    }

    public void setResultsSummaryManager(ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
    }
}

