/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.cloud.upgrade;

import com.atlassian.bamboo.migration.cloud.upgrade.AbstractFormerCloudUpgrade;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityDefaultsHelper;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityScope;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySetManager;
import com.atlassian.bamboo.v2.build.agent.capability.LocalCapabilitySet;
import com.atlassian.collectors.CollectorsUtil;
import com.google.common.collect.ImmutableList;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;

public class ResetServerCapabilities
extends AbstractFormerCloudUpgrade {
    @Autowired
    private CapabilityDefaultsHelper capabilityDefaultsHelper;
    @Autowired
    private CapabilitySetManager capabilitySetManager;

    public ResetServerCapabilities() {
        super("51209", "Reset server capabilities after exporting from Cloud");
    }

    protected String getRunOnlyOnceId() {
        return "com.atlassian.bamboo.migration.cloud.upgrade.ResetServerCapabilities";
    }

    protected void doRepeatableTask() {
        CapabilitySet capabilitySet = Optional.ofNullable(this.capabilitySetManager.getSharedLocalCapabilitySet()).orElse((CapabilitySet)new LocalCapabilitySet(CapabilityScope.SHARED));
        ((ImmutableList)capabilitySet.getCapabilities().stream().map(Capability::getKey).collect(CollectorsUtil.toImmutableList())).forEach(arg_0 -> ((CapabilitySet)capabilitySet).removeCapability(arg_0));
        this.capabilitySetManager.saveCapabilitySet(this.capabilityDefaultsHelper.addDefaultCapabilities(capabilitySet));
    }
}

