/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.cloud.upgrade;

import com.atlassian.bamboo.migration.cloud.upgrade.AbstractFormerCloudUpgrade;
import com.atlassian.bamboo.persistence.BambooTransactionHibernateTemplate;
import com.atlassian.bamboo.security.acegi.BambooAcegiSecurityUtils;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.security.acegi.acls.HibernateMutableAclService;
import java.util.Arrays;
import java.util.TreeSet;
import org.acegisecurity.acls.AccessControlEntry;
import org.acegisecurity.acls.MutableAcl;
import org.acegisecurity.acls.Permission;
import org.springframework.beans.factory.annotation.Autowired;

public class ConvertRestrictedAdmins
extends AbstractFormerCloudUpgrade {
    @Autowired
    private HibernateMutableAclService aclService;
    @Autowired
    private BambooTransactionHibernateTemplate bambooTransactionHibernateTemplate;

    public ConvertRestrictedAdmins() {
        super("51203", "Convert all restricted admins to regular admins");
    }

    protected String getRunOnlyOnceId() {
        return "com.atlassian.bamboo.migration.cloud.upgrade.ConvertRestrictedAdmin";
    }

    public void doRepeatableTask() {
        this.bambooTransactionHibernateTemplate.doWork(connection -> {
            TreeSet sidsWithRestrictedAdmin = new TreeSet(BambooAcegiSecurityUtils.sidComparator());
            TreeSet sidsWithAdmin = new TreeSet(BambooAcegiSecurityUtils.sidComparator());
            MutableAcl globalAcl = this.aclService.getAclOfGlobalPermission();
            Arrays.stream(globalAcl.getEntries()).filter(AccessControlEntry::isGranting).forEach(ace -> {
                if (BambooPermission.RESTRICTEDADMINISTRATION.equals((Object)ace.getPermission())) {
                    sidsWithRestrictedAdmin.add(ace.getSid());
                    globalAcl.deleteAce(ace.getId());
                } else if (BambooPermission.ADMINISTRATION.equals((Object)ace.getPermission())) {
                    sidsWithAdmin.add(ace.getSid());
                }
            });
            sidsWithRestrictedAdmin.removeAll(sidsWithAdmin);
            sidsWithRestrictedAdmin.forEach(sid -> globalAcl.insertAce(null, (Permission)BambooPermission.ADMINISTRATION, sid, true));
            this.aclService.updateAcl(globalAcl);
        });
    }
}

