/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.logger;

import com.atlassian.bamboo.logger.DecoratedErrorDetailsFactory;
import com.atlassian.bamboo.logger.DecoratedErrorDetailsImpl;
import com.atlassian.bamboo.logger.ErrorDetails;
import com.atlassian.bamboo.logger.ErrorHandler;
import com.atlassian.bamboo.ww2.actions.BuildActionSupport;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ViewBuildError
extends BuildActionSupport {
    private static final Logger log = Logger.getLogger(ViewBuildError.class);
    private String myError;
    private DecoratedErrorDetailsImpl errorDetails;
    private DecoratedErrorDetailsFactory decoratedErrorDetailsFactory;
    private ErrorHandler errorHandler;

    public String execute() throws Exception {
        try {
            int errorNumber = Integer.parseInt(this.myError);
            this.errorDetails = this.decorateErrorDetails(this.errorHandler.getErrorDetails(this.getBuildKey(), errorNumber));
        }
        catch (Exception e) {
            this.addActionError("Failed to obtain error from the log: " + e.getMessage());
            log.error((Object)"Failed to obtain error from the log", (Throwable)e);
        }
        return super.execute();
    }

    @Nullable
    private DecoratedErrorDetailsImpl decorateErrorDetails(@Nullable ErrorDetails errorDetails) {
        return errorDetails != null ? this.decoratedErrorDetailsFactory.decorate(errorDetails) : null;
    }

    public void setDecoratedErrorDetailsFactory(DecoratedErrorDetailsFactory decoratedErrorDetailsFactory) {
        this.decoratedErrorDetailsFactory = decoratedErrorDetailsFactory;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setError(String error) {
        this.myError = error;
    }

    public DecoratedErrorDetailsImpl getErrorDetails() {
        return this.errorDetails;
    }
}

