/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.logger;

import com.atlassian.bamboo.logger.DecoratedErrorDetailsFactory;
import com.atlassian.bamboo.logger.DecoratedErrorDetailsImpl;
import com.atlassian.bamboo.logger.ErrorAccessor;
import com.atlassian.bamboo.logger.ErrorDetails;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.security.BambooCachingPermissionManagerFacade;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.OptionalNarrow;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.google.common.base.Function;
import io.atlassian.util.concurrent.Lazy;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.acegisecurity.acls.Permission;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.support.TransactionOperations;

public class SystemErrorList
extends BambooActionSupport {
    private static final int MAX_SIZE = 100;
    @Autowired
    private ErrorAccessor errorAccessor;
    @Autowired
    private DecoratedErrorDetailsFactory decoratedErrorDetailsFactory;
    @Autowired
    private BambooCachingPermissionManagerFacade cachingPermissionManagerFacade;
    @Autowired
    private TransactionOperations transactionTemplate;
    private final Supplier<Collection<DecoratedErrorDetailsImpl>> someSystemErrors = Lazy.supplier(() -> this.getSystemErrorList(100));

    private Collection<DecoratedErrorDetailsImpl> getSystemErrorList(int maxSize) {
        Collection allErrors = this.errorAccessor.getAllErrors();
        Set<PlanKey> keysOfPermittedPlans = this.getKeysOfPermittedPlans(allErrors, maxSize);
        return (Collection)this.transactionTemplate.execute(tx -> allErrors.stream().filter(this.belongsToSystemErrorList(keysOfPermittedPlans)).map(arg_0 -> ((Function)this.decoratedErrorDetailsFactory.decorator()).apply(arg_0)).collect(Collectors.toList()));
    }

    private Predicate<? super ErrorDetails> belongsToSystemErrorList(Set<PlanKey> keysOfPermittedPlans) {
        return errorDetails -> {
            if (!errorDetails.isBuildSpecific()) {
                return true;
            }
            PlanKey planKey = (PlanKey)Narrow.downTo((Object)errorDetails.getEntityKey(), PlanKey.class);
            return planKey != null && keysOfPermittedPlans.contains(planKey);
        };
    }

    private Set<PlanKey> getKeysOfPermittedPlans(Collection<ErrorDetails> allErrors, int maxSize) {
        Stream<Set<Object>> allPlanKeys = allErrors.stream().map(ErrorDetails::getEntityKey).flatMap(OptionalNarrow.down(PlanKey.class)).distinct().limit(maxSize + 1);
        if (this.hasRestrictedAdminPermission()) {
            return allPlanKeys.collect(Collectors.toSet());
        }
        List allPlans = allPlanKeys.map(arg_0 -> ((CachedPlanManager)this.cachedPlanManager).getPlanByKey(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        this.cachingPermissionManagerFacade.primeAclCache(allPlans);
        return allPlans.stream().filter(plan -> this.cachingPermissionManagerFacade.hasPermission((Permission)BambooPermission.READ, plan)).map(PlanIdentifier::getPlanKey).collect(Collectors.toSet());
    }

    public Collection<DecoratedErrorDetailsImpl> getSystemErrors() {
        return this.someSystemErrors.get();
    }

    public Collection<DecoratedErrorDetailsImpl> getSystemErrors(int maxSize) {
        return this.getSystemErrorList(maxSize);
    }
}

